/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.support;

import java.net.URISyntaxException;
import java.net.URL;
import javax.persistence.spi.PersistenceUnitInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;

public class MergingPersistenceUnitManager
extends DefaultPersistenceUnitManager {
    private static final Logger LOG = LoggerFactory.getLogger(MergingPersistenceUnitManager.class);

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        super.postProcessPersistenceUnitInfo(pui);
        MutablePersistenceUnitInfo oldPui = this.getPersistenceUnitInfo(pui.getPersistenceUnitName());
        if (oldPui != null) {
            this.postProcessPersistenceUnitInfo(pui, (PersistenceUnitInfo)oldPui);
        }
    }

    protected boolean isPersistenceUnitOverrideAllowed() {
        return true;
    }

    void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui, PersistenceUnitInfo oldPui) {
        String persistenceUnitName = pui.getPersistenceUnitName();
        for (URL url : oldPui.getJarFileUrls()) {
            if (pui.getJarFileUrls().contains(url)) continue;
            LOG.debug("Adding JAR file URL {} to persistence unit {}.", (Object)url, (Object)persistenceUnitName);
            pui.addJarFileUrl(url);
        }
        for (String className : oldPui.getManagedClassNames()) {
            if (pui.getManagedClassNames().contains(className)) continue;
            LOG.debug("Adding class {} to PersistenceUnit {}", (Object)className, (Object)persistenceUnitName);
            pui.addManagedClassName(className);
        }
        for (String mappingFileName : oldPui.getMappingFileNames()) {
            if (pui.getMappingFileNames().contains(mappingFileName)) continue;
            LOG.debug("Adding mapping file to persistence unit {}.", (Object)mappingFileName, (Object)persistenceUnitName);
            pui.addMappingFileName(mappingFileName);
        }
        URL newUrl = pui.getPersistenceUnitRootUrl();
        URL oldUrl = oldPui.getPersistenceUnitRootUrl();
        if (oldUrl == null || newUrl == null) {
            return;
        }
        try {
            boolean urlNotInJarUrls;
            boolean rootUrlsDiffer = !newUrl.toURI().equals(oldUrl.toURI());
            boolean bl = urlNotInJarUrls = !pui.getJarFileUrls().contains(oldUrl);
            if (rootUrlsDiffer && urlNotInJarUrls) {
                pui.addJarFileUrl(oldUrl);
            }
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }
}

