/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.NonNull;
import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.PatchException;

class JsonLateObjectEvaluator
implements LateObjectEvaluator {
    @NonNull
    private final ObjectMapper mapper;
    @NonNull
    private final JsonNode valueNode;

    @Override
    public Object evaluate(Class<?> type) {
        try {
            return this.mapper.readValue(this.valueNode.traverse(this.mapper.getFactory().getCodec()), type);
        }
        catch (Exception o_O) {
            throw new PatchException(String.format("Could not read %s into %s!", this.valueNode, type), o_O);
        }
    }

    public JsonLateObjectEvaluator(@NonNull ObjectMapper mapper, @NonNull JsonNode valueNode) {
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is marked non-null but is null");
        }
        if (valueNode == null) {
            throw new IllegalArgumentException("valueNode is marked non-null but is null");
        }
        this.mapper = mapper;
        this.valueNode = valueNode;
    }
}

