/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.data.rest.webmvc.json.patch.SpelPath;
import org.springframework.util.ObjectUtils;

class TestOperation
extends PatchOperation {
    private TestOperation(SpelPath.UntypedSpelPath path, Object value) {
        super("test", path, value);
    }

    public static TestOperationBuilder whetherValueAt(String path) {
        return new TestOperationBuilder(path);
    }

    @Override
    void perform(Object target, Class<?> type) {
        Object actual;
        Object expected = TestOperation.normalizeIfNumber(this.evaluateValueFromTarget(target, type));
        if (!ObjectUtils.nullSafeEquals((Object)expected, (Object)(actual = TestOperation.normalizeIfNumber(this.path.bindTo(type).getValue(target))))) {
            throw new PatchException("Test against path '" + this.path + "' failed.");
        }
    }

    private static Object normalizeIfNumber(Object expected) {
        if (expected instanceof Double || expected instanceof Float) {
            expected = BigDecimal.valueOf(((Number)expected).doubleValue());
        } else if (expected instanceof Number) {
            expected = BigInteger.valueOf(((Number)expected).longValue());
        }
        return expected;
    }

    static class TestOperationBuilder {
        private final String path;

        public TestOperation hasValue(Object value) {
            return new TestOperation(SpelPath.untyped(this.path), value);
        }

        private TestOperationBuilder(String path) {
            this.path = path;
        }
    }
}

