/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Import;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.config.HateoasConfiguration;
import org.springframework.hateoas.config.HypermediaConfigurationImportSelector;
import org.springframework.hateoas.config.WebStackImportSelector;
import org.springframework.hateoas.support.WebStack;
import org.springframework.http.MediaType;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@Import(value={HypermediaConfigurationImportSelector.class, HateoasConfiguration.class, WebStackImportSelector.class})
public @interface EnableHypermediaSupport {
    public HypermediaType[] type();

    public WebStack[] stacks() default {WebStack.WEBMVC, WebStack.WEBFLUX};

    public static enum HypermediaType {
        HAL(MediaTypes.HAL_JSON),
        HAL_FORMS(MediaTypes.HAL_FORMS_JSON),
        COLLECTION_JSON(MediaTypes.COLLECTION_JSON),
        UBER(MediaTypes.UBER_JSON);

        private final List<MediaType> mediaTypes;

        private HypermediaType(MediaType ... mediaTypes) {
            this.mediaTypes = Arrays.asList(mediaTypes);
        }

        public List<MediaType> getMediaTypes() {
            return this.mediaTypes;
        }
    }
}

