/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.EntityLookupRegistrar;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.util.MethodInvocationRecorder;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

class EntityLookupConfiguration
implements EntityLookupRegistrar {
    private final List<LookupInformation<Object, Object, Repository<? extends Object, ?>>> lookupInformation = new ArrayList();
    private final List<Class<?>> lookupTypes = new ArrayList();

    EntityLookupConfiguration() {
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar forRepository(Class<R> repositoryType, Converter<T, ID> converter, EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
        new MappingBuilder(repositoryType).withIdMapping(converter).withLookup(lookup);
        return this;
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar.IdMappingRegistrar<T, R> forLookupRepository(Class<R> type) {
        this.lookupTypes.add(AbstractRepositoryMetadata.getMetadata(type).getDomainType());
        return this.forRepository(type);
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar.IdMappingRegistrar<T, R> forRepository(Class<R> type) {
        return new MappingBuilder(type);
    }

    @Override
    public <T, ID, R extends Repository<T, ?>> EntityLookupRegistrar forValueRepository(Class<R> type, Converter<T, ID> identifierMapping, EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
        this.lookupTypes.add(AbstractRepositoryMetadata.getMetadata(type).getDomainType());
        return this.forRepository(type, identifierMapping, lookup);
    }

    public List<EntityLookup<?>> getEntityLookups(Repositories repositories) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        return (List)this.lookupInformation.stream().map(it -> new RepositoriesEntityLookup(repositories, it)).collect(StreamUtils.toUnmodifiableList());
    }

    public boolean isLookupType(Class<?> type) {
        return this.lookupTypes.contains(type);
    }

    private static final class LookupInformation<T, ID, R extends Repository<? extends T, ?>> {
        private final Class<R> repositoryType;
        private final Converter<T, ID> identifierMapping;
        private final EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup;

        public LookupInformation(Class<R> repositoryType, Converter<T, ID> identifierMapping, EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
            this.repositoryType = repositoryType;
            this.identifierMapping = identifierMapping;
            this.lookup = lookup;
        }

        public Class<R> getRepositoryType() {
            return this.repositoryType;
        }

        public Converter<T, ID> getIdentifierMapping() {
            return this.identifierMapping;
        }

        public EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> getLookup() {
            return this.lookup;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LookupInformation)) {
                return false;
            }
            LookupInformation other = (LookupInformation)o;
            Class<R> this$repositoryType = this.getRepositoryType();
            Class<R> other$repositoryType = other.getRepositoryType();
            if (this$repositoryType == null ? other$repositoryType != null : !this$repositoryType.equals(other$repositoryType)) {
                return false;
            }
            Converter<T, ID> this$identifierMapping = this.getIdentifierMapping();
            Converter<T, ID> other$identifierMapping = other.getIdentifierMapping();
            if (this$identifierMapping == null ? other$identifierMapping != null : !this$identifierMapping.equals(other$identifierMapping)) {
                return false;
            }
            EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> this$lookup = this.getLookup();
            EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> other$lookup = other.getLookup();
            return !(this$lookup == null ? other$lookup != null : !this$lookup.equals(other$lookup));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<R> $repositoryType = this.getRepositoryType();
            result = result * 59 + ($repositoryType == null ? 43 : $repositoryType.hashCode());
            Converter<T, ID> $identifierMapping = this.getIdentifierMapping();
            result = result * 59 + ($identifierMapping == null ? 43 : $identifierMapping.hashCode());
            EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> $lookup = this.getLookup();
            result = result * 59 + ($lookup == null ? 43 : $lookup.hashCode());
            return result;
        }

        public String toString() {
            return "EntityLookupConfiguration.LookupInformation(repositoryType=" + this.getRepositoryType() + ", identifierMapping=" + this.getIdentifierMapping() + ", lookup=" + this.getLookup() + ")";
        }
    }

    private static class RepositoriesEntityLookup<T>
    implements EntityLookup<T> {
        private final LookupInformation<Object, Object, Repository<? extends T, ?>> lookupInfo;
        private final Repository<? extends T, ?> repository;
        private final Class<?> domainType;
        private final Optional<String> lookupProperty;

        public RepositoriesEntityLookup(Repositories repositories, LookupInformation<Object, Object, Repository<? extends T, ?>> lookupInformation) {
            Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
            Assert.notNull(lookupInformation, (String)"LookupInformation must not be null!");
            RepositoryInformation information = (RepositoryInformation)repositories.getRepositoryInformation(((LookupInformation)lookupInformation).repositoryType).orElseThrow(() -> new IllegalStateException("No repository found for type " + ((LookupInformation)lookupInformation).repositoryType.getName() + "!"));
            this.domainType = information.getDomainType();
            this.lookupInfo = lookupInformation;
            this.repository = (Repository)repositories.getRepositoryFor(information.getDomainType()).orElseThrow(() -> new IllegalStateException("No repository found for type " + information.getDomainType().getName() + "!"));
            this.lookupProperty = Optional.of(this.domainType).flatMap(it -> MethodInvocationRecorder.forProxyOf((Class)it).record(arg_0 -> ((Converter)((LookupInformation)this.lookupInfo).identifierMapping).convert(arg_0)).getPropertyPath());
        }

        @Override
        public Object getResourceIdentifier(T entity) {
            return this.lookupInfo.getIdentifierMapping().convert(entity);
        }

        @Override
        public Optional<T> lookupEntity(Object id) {
            Object result = this.lookupInfo.getLookup().lookup(this.repository, id);
            return Optional.class.isInstance(result) ? (Optional<Object>)result : Optional.ofNullable(result);
        }

        public boolean supports(Class<?> delimiter) {
            return this.domainType.isAssignableFrom(delimiter);
        }

        @Override
        public Optional<String> getLookupProperty() {
            return this.lookupProperty;
        }
    }

    private class MappingBuilder<T, ID, R extends Repository<T, ?>>
    implements EntityLookupRegistrar.LookupRegistrar<T, ID, R>,
    EntityLookupRegistrar.IdMappingRegistrar<T, R> {
        @NonNull
        private final Class<R> repositoryType;
        private Converter<T, ID> idMapping;

        private MappingBuilder(Class<R> repositoryType, Converter<T, ID> mapping) {
            this(repositoryType);
            Assert.notNull(mapping, (String)"Converter must not be null!");
            this.idMapping = mapping;
        }

        @Override
        public EntityLookupRegistrar withLookup(EntityLookupRegistrar.LookupRegistrar.Lookup<R, ID> lookup) {
            EntityLookupConfiguration.this.lookupInformation.add(new LookupInformation<T, ID, R>(this.repositoryType, this.idMapping, lookup));
            return EntityLookupConfiguration.this;
        }

        @Override
        public <ID2> EntityLookupRegistrar.LookupRegistrar<T, ID2, R> withIdMapping(Converter<T, ID2> idMapping) {
            return new MappingBuilder<T, ID2, R>(this.repositoryType, idMapping);
        }

        public MappingBuilder(Class<R> repositoryType) {
            if (repositoryType == null) {
                throw new IllegalArgumentException("repositoryType is marked non-null but is null");
            }
            this.repositoryType = repositoryType;
        }
    }
}

