/*
 * Decompiled with CFR 0.152.
 */
package com.example.schooltimetabling.domain;

import com.example.schooltimetabling.domain.Room;
import com.example.schooltimetabling.domain.Timeslot;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
@Entity
public class Lesson {
    @PlanningId
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @NotNull
    private Long id;
    @NotBlank
    private String subject;
    @NotBlank
    private String teacher;
    @NotBlank
    private String studentGroup;
    @PlanningVariable(valueRangeProviderRefs={"timeslotRange"})
    @ManyToOne
    private Timeslot timeslot;
    @PlanningVariable(valueRangeProviderRefs={"roomRange"})
    @ManyToOne
    private Room room;

    private Lesson() {
    }

    public Lesson(String subject, String teacher, String studentGroup) {
        this.subject = subject.trim();
        this.teacher = teacher.trim();
        this.studentGroup = studentGroup.trim();
    }

    public Lesson(long id, String subject, String teacher, String studentGroup, Room room, Timeslot timeslot) {
        this(subject, teacher, studentGroup);
        this.id = id;
        this.room = room;
        this.timeslot = timeslot;
    }

    public String toString() {
        return this.subject + "(" + this.id + ")";
    }

    public Long getId() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTeacher() {
        return this.teacher;
    }

    public String getStudentGroup() {
        return this.studentGroup;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public void setTimeslot(Timeslot timeslot) {
        this.timeslot = timeslot;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }
}

