/*
 * Decompiled with CFR 0.152.
 */
package com.example.schooltimetabling.persistence;

import com.example.schooltimetabling.domain.Lesson;
import com.example.schooltimetabling.domain.Room;
import com.example.schooltimetabling.domain.TimeTable;
import com.example.schooltimetabling.domain.Timeslot;
import com.example.schooltimetabling.persistence.LessonRepository;
import com.example.schooltimetabling.persistence.RoomRepository;
import com.example.schooltimetabling.persistence.TimeslotRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TimeTableRepository {
    public static final Long SINGLETON_TIME_TABLE_ID = 1L;
    @Autowired
    private TimeslotRepository timeslotRepository;
    @Autowired
    private RoomRepository roomRepository;
    @Autowired
    private LessonRepository lessonRepository;

    public TimeTable findById(Long id) {
        if (!SINGLETON_TIME_TABLE_ID.equals(id)) {
            throw new IllegalStateException("There is no timeTable with id (" + id + ").");
        }
        return new TimeTable((List<Timeslot>)this.timeslotRepository.findAll(), (List<Room>)this.roomRepository.findAll(), (List<Lesson>)this.lessonRepository.findAll());
    }

    public void save(TimeTable timeTable) {
        for (Lesson lesson : timeTable.getLessonList()) {
            this.lessonRepository.save(lesson);
        }
    }
}

