/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.mutation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TestGenRemoveRandomBlockMutator<T> {
    private final List<T> list;
    private final Random random = new Random(0L);
    private final List<Integer> indexBlacklist = new ArrayList<Integer>();
    private int blockPortion = 10;
    private int removedIndex = -1;
    private List<T> removedBlock;

    public TestGenRemoveRandomBlockMutator(List<T> list) {
        this.list = new ArrayList<T>(list);
    }

    public boolean canMutate() {
        return !this.list.isEmpty() && this.list.size() > this.indexBlacklist.size();
    }

    public List<T> mutate() {
        if (!this.canMutate()) {
            throw new IllegalStateException("No more mutations possible.");
        }
        if (this.removedIndex >= 0) {
            this.indexBlacklist.clear();
        }
        int blockSize = Math.max(this.list.size() / this.blockPortion, 1);
        if (this.indexBlacklist.size() == this.list.size() / blockSize && this.list.size() / this.blockPortion > 1) {
            this.blockPortion *= 2;
            this.indexBlacklist.clear();
        }
        blockSize = Math.max(this.list.size() / this.blockPortion, 1);
        do {
            this.removedIndex = this.random.nextInt(this.list.size() / blockSize) * blockSize;
        } while (this.indexBlacklist.contains(this.removedIndex));
        this.removedBlock = new ArrayList<T>(this.list.subList(this.removedIndex, this.removedIndex + blockSize));
        this.list.removeAll(this.removedBlock);
        return this.list;
    }

    public void revert() {
        this.list.addAll(this.removedIndex, this.removedBlock);
        this.indexBlacklist.add(this.removedIndex);
        this.removedIndex = -1;
    }

    public List<T> getResult() {
        return this.list;
    }

    public List<T> getRemovedBlock() {
        return this.removedBlock;
    }
}

