/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoft;

import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardMediumSoftScoreHolder
extends AbstractScoreHolder {
    protected int hardScore;
    protected int mediumScore;
    protected int softScore;

    public HardMediumSoftScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftScore.ZERO);
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getMediumScore() {
        return this.mediumScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardMediumSoftScore.valueOf(hardWeight, 0, 0));
    }

    public void addMediumConstraintMatch(RuleContext kcontext, int mediumWeight) {
        this.mediumScore += mediumWeight;
        this.registerConstraintMatch(kcontext, () -> this.mediumScore -= mediumWeight, () -> HardMediumSoftScore.valueOf(0, mediumWeight, 0));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardMediumSoftScore.valueOf(0, 0, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, int hardWeight, int mediumWeight, int softWeight) {
        this.hardScore += hardWeight;
        this.mediumScore += mediumWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.mediumScore -= mediumWeight;
            this.softScore -= softWeight;
        }, () -> HardMediumSoftScore.valueOf(hardWeight, mediumWeight, softWeight));
    }

    @Override
    public Score extractScore(int initScore) {
        return HardMediumSoftScore.valueOfUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }
}

