/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;

public abstract class VariableDescriptor<Solution_> {
    protected final EntityDescriptor<Solution_> entityDescriptor;
    protected final MemberAccessor variableMemberAccessor;
    protected final String variableName;
    protected List<ShadowVariableDescriptor<Solution_>> sinkVariableDescriptorList = new ArrayList<ShadowVariableDescriptor<Solution_>>(4);

    public VariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        this.entityDescriptor = entityDescriptor;
        this.variableMemberAccessor = variableMemberAccessor;
        this.variableName = variableMemberAccessor.getName();
        if (variableMemberAccessor.getType().isPrimitive()) {
            throw new IllegalStateException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated member (" + variableMemberAccessor + ") that returns a primitive type (" + variableMemberAccessor.getType() + "). This means it cannot represent an uninitialized variable as null and the Construction Heuristics think it's already initialized.\nMaybe let the member (" + this.getSimpleEntityAndVariableName() + ") return its primitive wrapper type instead.");
        }
    }

    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getSimpleEntityAndVariableName() {
        return this.entityDescriptor.getEntityClass().getSimpleName() + "." + this.variableName;
    }

    public Class<?> getVariablePropertyType() {
        return this.variableMemberAccessor.getType();
    }

    public void registerSinkVariableDescriptor(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.sinkVariableDescriptorList.add(shadowVariableDescriptor);
    }

    public List<ShadowVariableDescriptor<Solution_>> getSinkVariableDescriptorList() {
        return this.sinkVariableDescriptorList;
    }

    public boolean isValuePotentialAnchor(Object value) {
        return !this.entityDescriptor.getEntityClass().isAssignableFrom(value.getClass());
    }

    public Object getValue(Object entity) {
        return this.variableMemberAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variableMemberAccessor.executeSetter(entity, value);
    }

    public abstract boolean isGenuineAndUninitialized(Object var1);
}

