/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

public class ShiftAssignmentSwapMove
extends AbstractMove<NurseRoster> {
    private ShiftAssignment leftShiftAssignment;
    private ShiftAssignment rightShiftAssignment;

    public ShiftAssignmentSwapMove(ShiftAssignment leftShiftAssignment, ShiftAssignment rightShiftAssignment) {
        this.leftShiftAssignment = leftShiftAssignment;
        this.rightShiftAssignment = rightShiftAssignment;
    }

    public boolean isMoveDoable(ScoreDirector<NurseRoster> scoreDirector) {
        return !Objects.equals(this.leftShiftAssignment.getEmployee(), this.rightShiftAssignment.getEmployee());
    }

    public ShiftAssignmentSwapMove createUndoMove(ScoreDirector<NurseRoster> scoreDirector) {
        return new ShiftAssignmentSwapMove(this.rightShiftAssignment, this.leftShiftAssignment);
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<NurseRoster> scoreDirector) {
        Employee oldLeftEmployee = this.leftShiftAssignment.getEmployee();
        Employee oldRightEmployee = this.rightShiftAssignment.getEmployee();
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.leftShiftAssignment, oldRightEmployee);
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.rightShiftAssignment, oldLeftEmployee);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftShiftAssignment, this.rightShiftAssignment);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftShiftAssignment.getEmployee(), this.rightShiftAssignment.getEmployee());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ShiftAssignmentSwapMove) {
            ShiftAssignmentSwapMove other = (ShiftAssignmentSwapMove)((Object)o);
            return new EqualsBuilder().append((Object)this.leftShiftAssignment, (Object)other.leftShiftAssignment).append((Object)this.rightShiftAssignment, (Object)other.rightShiftAssignment).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftShiftAssignment).append((Object)this.rightShiftAssignment).toHashCode();
    }

    public String toString() {
        return this.leftShiftAssignment + " {" + this.leftShiftAssignment.getEmployee() + "} <-> " + this.rightShiftAssignment + " {" + this.rightShiftAssignment.getEmployee() + "}";
    }
}

