/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftlong;

import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.score.inliner.LongWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class HardSoftLongScoreInliner
extends ScoreInliner<HardSoftLongScore> {
    protected long hardScore;
    protected long softScore;

    protected HardSoftLongScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public LongWeightedScoreImpacter buildWeightedScoreImpacter(HardSoftLongScore constraintWeight) {
        if (constraintWeight.equals(HardSoftLongScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        long hardConstraintWeight = constraintWeight.getHardScore();
        long softConstraintWeight = constraintWeight.getSoftScore();
        if (softConstraintWeight == 0L) {
            return (matchWeight, matchScoreConsumer) -> {
                long hardImpact = hardConstraintWeight * matchWeight;
                this.hardScore += hardImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardSoftLongScore.ofHard(hardImpact));
                }
                return () -> this.hardScore -= hardImpact;
            };
        }
        if (hardConstraintWeight == 0L) {
            return (matchWeight, matchScoreConsumer) -> {
                long softImpact = softConstraintWeight * matchWeight;
                this.softScore += softImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardSoftLongScore.ofSoft(softImpact));
                }
                return () -> this.softScore -= softImpact;
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            long hardImpact = hardConstraintWeight * matchWeight;
            long softImpact = softConstraintWeight * matchWeight;
            this.hardScore += hardImpact;
            this.softScore += softImpact;
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(HardSoftLongScore.of(hardImpact, softImpact));
            }
            return () -> {
                this.hardScore -= hardImpact;
                this.softScore -= softImpact;
            };
        };
    }

    @Override
    public HardSoftLongScore extractScore(int initScore) {
        return HardSoftLongScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }

    public String toString() {
        return HardSoftLongScore.class.getSimpleName() + " inliner";
    }
}

