/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;

public class SelectedCountLimitEntitySelector
extends AbstractEntitySelector {
    protected final EntitySelector childEntitySelector;
    protected final boolean randomSelection;
    protected final long selectedCountLimit;

    public SelectedCountLimitEntitySelector(EntitySelector childEntitySelector, boolean randomSelection, long selectedCountLimit) {
        this.childEntitySelector = childEntitySelector;
        this.randomSelection = randomSelection;
        this.selectedCountLimit = selectedCountLimit;
        if (selectedCountLimit < 0L) {
            throw new IllegalArgumentException("The selector (" + this + ") has a negative selectedCountLimit (" + selectedCountLimit + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize() {
        long childSize = this.childEntitySelector.getSize();
        return Math.min(this.selectedCountLimit, childSize);
    }

    @Override
    public Iterator<Object> iterator() {
        return new SelectedCountLimitEntityIterator(this.childEntitySelector.iterator());
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> endingIterator() {
        if (this.randomSelection) {
            return this.childEntitySelector.endingIterator();
        }
        return new SelectedCountLimitEntityIterator(this.childEntitySelector.endingIterator());
    }

    public String toString() {
        return "SelectedCountLimit(" + this.childEntitySelector + ")";
    }

    private class SelectedCountLimitEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> childEntityIterator;
        private long selectedSize;

        public SelectedCountLimitEntityIterator(Iterator<Object> childEntityIterator) {
            this.childEntityIterator = childEntityIterator;
            this.selectedSize = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.selectedSize < SelectedCountLimitEntitySelector.this.selectedCountLimit && this.childEntityIterator.hasNext();
        }

        @Override
        public Object next() {
            if (this.selectedSize >= SelectedCountLimitEntitySelector.this.selectedCountLimit) {
                throw new NoSuchElementException();
            }
            ++this.selectedSize;
            return this.childEntityIterator.next();
        }
    }
}

