/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.simple;

import java.io.IOException;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;

public class BeliefSystemLogicalCallback
extends PropagationEntry.AbstractPropagationEntry
implements WorkingMemoryAction {
    protected InternalFactHandle handle;
    protected PropagationContext context;
    protected Activation activation;
    protected boolean update;
    protected boolean fullyRetract;

    public BeliefSystemLogicalCallback() {
    }

    public BeliefSystemLogicalCallback(InternalFactHandle handle, PropagationContext context, Activation activation, boolean update, boolean fullyRetract) {
        this.handle = handle;
        this.context = context;
        this.activation = activation;
        this.update = update;
        this.fullyRetract = fullyRetract;
    }

    public BeliefSystemLogicalCallback(MarshallerReaderContext context) throws IOException {
        this.handle = context.getHandles().get(context.readLong());
        this.context = context.getPropagationContexts().get(context.readLong());
        this.activation = (Activation)context.getTerminalTupleMap().get(context.readInt()).getContextObject();
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isFullyRetract() {
        return this.fullyRetract;
    }

    public void setFullyRetract(boolean fullyRetract) {
        this.fullyRetract = fullyRetract;
    }

    @Override
    public void execute(InternalWorkingMemory workingMemory) {
        NamedEntryPoint nep = (NamedEntryPoint)this.handle.getEntryPoint(workingMemory);
        BeliefSet bs = this.handle.getEqualityKey().getBeliefSet();
        bs.setWorkingMemoryAction(null);
        if (this.update) {
            if (!bs.isEmpty()) {
                nep.update(this.handle, this.handle.getObject(), PropertySpecificUtil.allSetButTraitBitMask(), (Class<?>)Object.class, (Activation)null);
            }
        } else if (this.fullyRetract) {
            nep.delete(this.handle, this.context.getRuleOrigin(), (TerminalNode)this.activation.getTuple().getTupleSink());
        } else {
            ObjectTypeConf typeConf = nep.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(nep.getEntryPoint(), this.handle.getObject());
            nep.getEntryPointNode().retractObject(this.handle, this.context, typeConf, workingMemory);
        }
    }
}

