/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.io.Serializable;
import java.security.AccessController;
import org.drools.core.WorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Invoker;
import org.drools.core.spi.KnowledgeHelper;
import org.kie.internal.security.KiePolicyHelper;

public interface Consequence
extends Invoker {
    public String getName();

    public void evaluate(KnowledgeHelper var1, WorkingMemory var2) throws Exception;

    default public void initDeclarations(Declaration[] requiredDeclarations) {
    }

    public static boolean isCompiledInvoker(Consequence consequence) {
        return consequence instanceof CompiledInvoker || consequence instanceof SafeConsequence && ((SafeConsequence)consequence).wrapsCompiledInvoker();
    }

    public static class SafeConsequence
    implements Consequence,
    Serializable {
        private static final long serialVersionUID = -8109957972163261899L;
        private final Consequence delegate;

        public SafeConsequence(Consequence delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            AccessController.doPrivileged(() -> {
                this.delegate.evaluate(knowledgeHelper, workingMemory);
                return null;
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public void initDeclarations(Declaration[] requiredDeclarations) {
            this.delegate.initDeclarations(requiredDeclarations);
        }

        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

