/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;

public class StepCountTermination
extends AbstractTermination {
    private final int stepCountLimit;

    public StepCountTermination(int stepCountLimit) {
        this.stepCountLimit = stepCountLimit;
        if (stepCountLimit < 0) {
            throw new IllegalArgumentException("The stepCountLimit (" + stepCountLimit + ") cannot be negative.");
        }
    }

    public int getStepCountLimit() {
        return this.stepCountLimit;
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used for phase termination.");
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        int nextStepIndex = phaseScope.getNextStepIndex();
        return nextStepIndex >= this.stepCountLimit;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used for phase termination.");
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        int nextStepIndex = phaseScope.getNextStepIndex();
        double timeGradient = (double)nextStepIndex / (double)this.stepCountLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public StepCountTermination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        return new StepCountTermination(this.stepCountLimit);
    }

    public String toString() {
        return "StepCount(" + this.stepCountLimit + ")";
    }
}

