/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain.solver;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.Course;

public class CourseConflict
implements Serializable,
Comparable<CourseConflict> {
    private static final Comparator<Course> COURSE_COMPARATOR = Comparator.comparingLong(AbstractPersistable::getId);
    private static final Comparator<CourseConflict> COMPARATOR = Comparator.comparing(CourseConflict::getLeftCourse, COURSE_COMPARATOR).thenComparing(CourseConflict::getRightCourse, COURSE_COMPARATOR);
    private final Course leftCourse;
    private final Course rightCourse;
    private final int conflictCount;

    public CourseConflict(Course leftCourse, Course rightCourse, int conflictCount) {
        this.leftCourse = leftCourse;
        this.rightCourse = rightCourse;
        this.conflictCount = conflictCount;
    }

    public Course getLeftCourse() {
        return this.leftCourse;
    }

    public Course getRightCourse() {
        return this.rightCourse;
    }

    public int getConflictCount() {
        return this.conflictCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CourseConflict other = (CourseConflict)o;
        return Objects.equals(this.leftCourse, other.leftCourse) && Objects.equals(this.rightCourse, other.rightCourse);
    }

    public int hashCode() {
        return Objects.hash(this.leftCourse, this.rightCourse);
    }

    @Override
    public int compareTo(CourseConflict other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.leftCourse + " & " + this.rightCourse;
    }
}

