/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;

public final class NearbyDistanceMatrix {
    private final NearbyDistanceMeter nearbyDistanceMeter;
    private final Map<Object, Object[]> originToDestinationsMap;

    public NearbyDistanceMatrix(NearbyDistanceMeter nearbyDistanceMeter, int originSize) {
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.originToDestinationsMap = new HashMap<Object, Object[]>(originSize);
    }

    public void addAllDestinations(Object origin, Iterator<Object> destinationIterator, int destinationSize) {
        Object[] destinations = new Object[destinationSize];
        double[] distances = new double[destinationSize];
        int size = 0;
        Double highestDistance = Double.MAX_VALUE;
        while (destinationIterator.hasNext()) {
            Object destination = destinationIterator.next();
            double distance = this.nearbyDistanceMeter.getNearbyDistance(origin, destination);
            if (!(distance < highestDistance) && size >= destinationSize) continue;
            int insertIndex = Arrays.binarySearch(distances, 0, size, distance);
            if (insertIndex < 0) {
                insertIndex = -insertIndex - 1;
            } else {
                while (insertIndex < size && distances[insertIndex] == distance) {
                    ++insertIndex;
                }
            }
            if (size < destinationSize) {
                ++size;
            }
            System.arraycopy(destinations, insertIndex, destinations, insertIndex + 1, size - insertIndex - 1);
            System.arraycopy(distances, insertIndex, distances, insertIndex + 1, size - insertIndex - 1);
            destinations[insertIndex] = destination;
            distances[insertIndex] = distance;
            highestDistance = distances[size - 1];
        }
        if (size != destinationSize) {
            throw new IllegalStateException("The destinationIterator's size (" + size + ") differs from the expected destinationSize (" + destinationSize + ").");
        }
        this.originToDestinationsMap.put(origin, destinations);
    }

    public Object getDestination(Object origin, int nearbyIndex) {
        Object[] destinations = this.originToDestinationsMap.get(origin);
        return destinations[nearbyIndex];
    }
}

