/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.domain;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Set;
import org.optaplanner.examples.common.domain.AbstractPersistable;

public class Timeslot
extends AbstractPersistable {
    private LocalDateTime startDateTime;
    private LocalDateTime endDateTime;
    private String talkType;
    private Set<String> tagSet;

    public Timeslot() {
    }

    public Timeslot(long id) {
        super(id);
    }

    public LocalDate getDate() {
        return this.startDateTime.toLocalDate();
    }

    public long getDurationInMinutes() {
        return Duration.between(this.startDateTime, this.endDateTime).toMinutes();
    }

    public boolean overlaps(Timeslot other) {
        if (this == other) {
            return true;
        }
        return this.startDateTime.compareTo(other.endDateTime) < 0 && other.startDateTime.compareTo(this.endDateTime) < 0;
    }

    public boolean hasTag(String tag) {
        return this.tagSet.contains(tag);
    }

    @Override
    public String toString() {
        return this.startDateTime + "-" + this.endDateTime.toLocalTime();
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public String getTalkType() {
        return this.talkType;
    }

    public void setTalkType(String talkType) {
        this.talkType = talkType;
    }

    public Set<String> getTagSet() {
        return this.tagSet;
    }

    public void setTagSet(Set<String> tagSet) {
        this.tagSet = tagSet;
    }

    public Timeslot withTalkType(String talkType) {
        this.talkType = talkType;
        return this;
    }

    public Timeslot withStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public Timeslot withEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }
}

