/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain.solver;

import com.google.common.base.Functions;
import java.util.Collections;
import java.util.Comparator;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

public class PeriodStrengthWeightFactory
implements SelectionSorterWeightFactory<CourseSchedule, Period> {
    public PeriodStrengthWeight createSorterWeight(CourseSchedule schedule, Period period) {
        int unavailablePeriodPenaltyCount = 0;
        for (UnavailablePeriodPenalty penalty : schedule.getUnavailablePeriodPenaltyList()) {
            if (!penalty.getPeriod().equals(period)) continue;
            ++unavailablePeriodPenaltyCount;
        }
        return new PeriodStrengthWeight(period, unavailablePeriodPenaltyCount);
    }

    public static class PeriodStrengthWeight
    implements Comparable<PeriodStrengthWeight> {
        private static final Comparator<PeriodStrengthWeight> BASE_COMPARATOR = Collections.reverseOrder(Comparator.comparingInt(w -> w.unavailablePeriodPenaltyCount));
        private static final Comparator<Period> PERIOD_COMPARATOR = Comparator.comparingInt(p -> p.getDay().getDayIndex()).thenComparingInt(p -> p.getTimeslot().getTimeslotIndex()).thenComparingLong(AbstractPersistable::getId);
        private static final Comparator<PeriodStrengthWeight> COMPARATOR = Comparator.comparing(Functions.identity(), BASE_COMPARATOR).thenComparing(w -> w.period, PERIOD_COMPARATOR);
        private final Period period;
        private final int unavailablePeriodPenaltyCount;

        public PeriodStrengthWeight(Period period, int unavailablePeriodPenaltyCount) {
            this.period = period;
            this.unavailablePeriodPenaltyCount = unavailablePeriodPenaltyCount;
        }

        @Override
        public int compareTo(PeriodStrengthWeight other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

