/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.composite;

import java.util.Iterator;
import java.util.Random;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.AbstractCountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.util.ValueRangeIterator;
import org.optaplanner.core.impl.solver.random.RandomUtils;

public class NullableCountableValueRange<T>
extends AbstractCountableValueRange<T> {
    private final CountableValueRange<T> childValueRange;
    private final long size;

    public NullableCountableValueRange(CountableValueRange<T> childValueRange) {
        this.childValueRange = childValueRange;
        this.size = childValueRange.getSize() + 1L;
    }

    public ValueRange<T> getChildValueRange() {
        return this.childValueRange;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public T get(long index) {
        if (index == this.size - 1L) {
            return null;
        }
        return this.childValueRange.get(index);
    }

    @Override
    public boolean contains(T value) {
        if (value == null) {
            return true;
        }
        return this.childValueRange.contains(value);
    }

    @Override
    public Iterator<T> createOriginalIterator() {
        return new OriginalNullValueRangeIterator(this.childValueRange.createOriginalIterator());
    }

    @Override
    public Iterator<T> createRandomIterator(Random workingRandom) {
        return new RandomNullValueRangeIterator(workingRandom);
    }

    public String toString() {
        return "[null]\u222a" + this.childValueRange;
    }

    private class RandomNullValueRangeIterator
    extends ValueRangeIterator<T> {
        private final Random workingRandom;

        public RandomNullValueRangeIterator(Random workingRandom) {
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            long index = RandomUtils.nextLong(this.workingRandom, NullableCountableValueRange.this.size);
            return NullableCountableValueRange.this.get(index);
        }
    }

    private class OriginalNullValueRangeIterator
    extends ValueRangeIterator<T> {
        private boolean nullReturned = false;
        private final Iterator<T> childIterator;

        public OriginalNullValueRangeIterator(Iterator<T> childIterator) {
            this.childIterator = childIterator;
        }

        @Override
        public boolean hasNext() {
            return !this.nullReturned || this.childIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.nullReturned) {
                this.nullReturned = true;
                return null;
            }
            return this.childIterator.next();
        }
    }
}

