/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class ConnectionFollowRedirects {
    private URLConnection connection;
    private boolean isRedirect;
    private int redirects = 0;

    public ConnectionFollowRedirects(String url) throws IOException {
        this.connection = new URL(url).openConnection();
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public int getRedirects() {
        return this.redirects;
    }

    public InputStream getInputStream() throws IOException {
        InputStream in = null;
        do {
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).setInstanceFollowRedirects(false);
            }
            in = this.connection.getInputStream();
            this.followRedirects();
        } while (this.isRedirect);
        return in;
    }

    private void followRedirects() throws IOException {
        HttpURLConnection http;
        int stat;
        this.isRedirect = false;
        if (this.connection instanceof HttpURLConnection && (stat = (http = (HttpURLConnection)this.connection).getResponseCode()) >= 300 && stat <= 307 && stat != 306 && stat != 304) {
            this.redirectConnection(http);
        }
    }

    private void redirectConnection(HttpURLConnection http) throws IOException {
        URL base = http.getURL();
        String location = http.getHeaderField("Location");
        URL target = null;
        if (location != null) {
            target = new URL(base, location);
        }
        http.disconnect();
        if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || this.redirects >= 5) {
            throw new SecurityException("illegal URL redirect");
        }
        this.isRedirect = true;
        this.connection = target.openConnection();
        ++this.redirects;
    }
}

