/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.move.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.optaplanner.core.impl.heuristic.move.CompositeMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.random.RandomUtils;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.optaplanner.examples.investment.solver.move.InvestmentQuantityTransferMove;

public class InvestmentBiQuantityTransferMoveIteratorFactory
implements MoveIteratorFactory<InvestmentSolution> {
    public long getSize(ScoreDirector<InvestmentSolution> scoreDirector) {
        InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
        int size = solution.getAssetClassAllocationList().size();
        return 1000000L * (long)(size - 1) * (long)(size - 1);
    }

    public Iterator<Move<InvestmentSolution>> createOriginalMoveIterator(ScoreDirector<InvestmentSolution> scoreDirector) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Move<InvestmentSolution>> createRandomMoveIterator(ScoreDirector<InvestmentSolution> scoreDirector, Random workingRandom) {
        InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
        List<AssetClassAllocation> allocationList = solution.getAssetClassAllocationList();
        ArrayList<AssetClassAllocation> nonEmptyAllocationList = new ArrayList<AssetClassAllocation>(allocationList);
        nonEmptyAllocationList.removeIf(allocation -> allocation.getQuantityMillis() == 0L);
        return new RandomInvestmentBiQuantityTransferMoveIterator(allocationList, nonEmptyAllocationList, workingRandom);
    }

    private static class RandomInvestmentBiQuantityTransferMoveIterator
    implements Iterator<Move<InvestmentSolution>> {
        private final List<AssetClassAllocation> allocationList;
        private final List<AssetClassAllocation> nonEmptyAllocationList;
        private final Random workingRandom;

        public RandomInvestmentBiQuantityTransferMoveIterator(List<AssetClassAllocation> allocationList, List<AssetClassAllocation> nonEmptyAllocationList, Random workingRandom) {
            this.allocationList = allocationList;
            this.nonEmptyAllocationList = nonEmptyAllocationList;
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return this.allocationList.size() >= 3 && this.nonEmptyAllocationList.size() >= 1;
        }

        @Override
        public Move<InvestmentSolution> next() {
            AssetClassAllocation secondFrom;
            AssetClassAllocation firstFrom;
            int nonEmptyAllocationListSize = this.nonEmptyAllocationList.size();
            if (nonEmptyAllocationListSize == 1) {
                secondFrom = firstFrom = this.nonEmptyAllocationList.get(0);
            } else {
                firstFrom = this.nonEmptyAllocationList.get(this.workingRandom.nextInt(nonEmptyAllocationListSize));
                secondFrom = this.nonEmptyAllocationList.get(this.workingRandom.nextInt(nonEmptyAllocationListSize));
            }
            int allocationListSize = this.allocationList.size();
            int toCandidateSize = allocationListSize - (firstFrom == secondFrom ? 1 : 2);
            AssetClassAllocation firstTo = this.allocationList.get(this.workingRandom.nextInt(toCandidateSize));
            if (firstTo == firstFrom) {
                firstTo = this.allocationList.get(allocationListSize - 1);
            } else if (firstTo == secondFrom) {
                firstTo = this.allocationList.get(allocationListSize - 2);
            }
            AssetClassAllocation secondTo = this.allocationList.get(this.workingRandom.nextInt(toCandidateSize));
            if (secondTo == firstFrom) {
                secondTo = this.allocationList.get(allocationListSize - 1);
            } else if (secondTo == secondFrom) {
                secondTo = this.allocationList.get(allocationListSize - 2);
            }
            long firstTransferMillis = RandomUtils.nextLong((Random)this.workingRandom, (long)firstFrom.getQuantityMillis()) + 1L;
            if (firstFrom == secondFrom && firstFrom.getQuantityMillis() == firstTransferMillis) {
                --firstTransferMillis;
            }
            long secondTransferMillis = RandomUtils.nextLong((Random)this.workingRandom, (long)(secondFrom.getQuantityMillis() - (firstFrom == secondFrom ? firstTransferMillis : 0L))) + 1L;
            return CompositeMove.buildMove((Move[])new InvestmentQuantityTransferMove[]{new InvestmentQuantityTransferMove(firstFrom, firstTo, firstTransferMillis), new InvestmentQuantityTransferMove(secondFrom, secondTo, secondTransferMillis)});
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The optional operation remove() is not supported.");
        }
    }
}

