/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.quad;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.SingleQuadJoiner;

public final class CompositeQuadJoiner<A, B, C, D>
extends AbstractQuadJoiner<A, B, C, D> {
    private final List<SingleQuadJoiner<A, B, C, D>> joinerList;
    private final JoinerType[] joinerTypes;
    private final TriFunction<A, B, C, ?>[] leftMappings;
    private final Function<D, ?>[] rightMappings;

    CompositeQuadJoiner(List<SingleQuadJoiner<A, B, C, D>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
        this.joinerTypes = (JoinerType[])joinerList.stream().map(SingleQuadJoiner::getJoinerType).toArray(JoinerType[]::new);
        this.leftMappings = (TriFunction[])joinerList.stream().map(SingleQuadJoiner::getLeftMapping).toArray(TriFunction[]::new);
        this.rightMappings = (Function[])joinerList.stream().map(SingleQuadJoiner::getRightMapping).toArray(Function[]::new);
    }

    public List<SingleQuadJoiner<A, B, C, D>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public TriFunction<A, B, C, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    @Override
    public TriFunction<A, B, C, Object[]> getLeftCombinedMapping() {
        return (a, b, c) -> Arrays.stream(this.leftMappings).map(f -> f.apply(a, b, c)).toArray();
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return this.joinerTypes;
    }

    @Override
    public Function<D, Object> getRightMapping(int index) {
        return this.rightMappings[index];
    }

    @Override
    public Function<D, Object[]> getRightCombinedMapping() {
        return d -> Arrays.stream(this.rightMappings).map(f -> f.apply(d)).toArray();
    }
}

