/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.Application;
import org.kie.kogito.Config;
import org.kie.kogito.KogitoEngine;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.uow.UnitOfWorkManager;

public class StaticApplication
implements Application {
    protected Config config;
    private final Map<Class<? extends KogitoEngine>, KogitoEngine> engineMap = new HashMap<Class<? extends KogitoEngine>, KogitoEngine>();

    public StaticApplication() {
    }

    public StaticApplication(Config config, KogitoEngine ... engines) {
        this.config = config;
        this.loadEngines(engines);
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public <T extends KogitoEngine> T get(Class<T> clazz) {
        return (T)((KogitoEngine)this.engineMap.entrySet().stream().filter(entry -> clazz.isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null));
    }

    protected void loadEngines(KogitoEngine ... engines) {
        Arrays.stream(engines).forEach(this::loadEngine);
        if (this.config() != null && this.config().get(ProcessConfig.class) != null) {
            this.unitOfWorkManager().eventManager().setAddons(this.config().addons());
        }
    }

    protected void loadEngine(KogitoEngine engine) {
        if (engine != null) {
            this.engineMap.put(engine.getClass(), engine);
        }
    }

    @Override
    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().get(ProcessConfig.class).unitOfWorkManager();
    }
}

