/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.modelcompiler.ExecutableModelProject;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.utils.KieHelper;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenDroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.easy.EasyScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class ScoreDirectorFactoryFactory<Solution_, Score_ extends Score<Score_>> {
    private static final String GENERATE_DROOLS_TEST_ON_ERROR_PROPERTY_NAME = "optaplanner.drools.generateTestOnError";
    private final ScoreDirectorFactoryConfig config;

    public ScoreDirectorFactoryFactory(ScoreDirectorFactoryConfig config) {
        this.config = config;
    }

    public InnerScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(ClassLoader classLoader, EnvironmentMode environmentMode, SolutionDescriptor<Solution_> solutionDescriptor) {
        AbstractScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.decideMultipleScoreDirectorFactories(classLoader, solutionDescriptor);
        if (this.config.getAssertionScoreDirectorFactory() != null) {
            if (this.config.getAssertionScoreDirectorFactory().getAssertionScoreDirectorFactory() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.config.getAssertionScoreDirectorFactory() + ") cannot have a non-null assertionScoreDirectorFactory (" + this.config.getAssertionScoreDirectorFactory().getAssertionScoreDirectorFactory() + ").");
            }
            if (environmentMode.compareTo(EnvironmentMode.FAST_ASSERT) > 0) {
                throw new IllegalArgumentException("A non-null assertionScoreDirectorFactory (" + this.config.getAssertionScoreDirectorFactory() + ") requires an environmentMode (" + (Object)((Object)environmentMode) + ") of " + (Object)((Object)EnvironmentMode.FAST_ASSERT) + " or lower.");
            }
            ScoreDirectorFactoryFactory<Solution_, Score_> assertionScoreDirectorFactoryFactory = new ScoreDirectorFactoryFactory<Solution_, Score_>(this.config.getAssertionScoreDirectorFactory());
            scoreDirectorFactory.setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryFactory.buildScoreDirectorFactory(classLoader, EnvironmentMode.NON_REPRODUCIBLE, solutionDescriptor));
        }
        scoreDirectorFactory.setInitializingScoreTrend(InitializingScoreTrend.parseTrend(this.config.getInitializingScoreTrend() == null ? InitializingScoreTrendLevel.ANY.name() : this.config.getInitializingScoreTrend(), solutionDescriptor.getScoreDefinition().getLevelsSize()));
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            scoreDirectorFactory.setAssertClonedSolution(true);
        }
        return scoreDirectorFactory;
    }

    protected AbstractScoreDirectorFactory<Solution_, Score_> decideMultipleScoreDirectorFactories(ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor) {
        AbstractScoreDirectorFactory scoreDirectorFactory;
        EasyScoreDirectorFactory<Solution_, Score_> easyScoreDirectorFactory = this.buildEasyScoreDirectorFactory(solutionDescriptor);
        ConstraintStreamScoreDirectorFactory<Solution_, Score_> constraintStreamScoreDirectorFactory = this.buildConstraintStreamScoreDirectorFactory(solutionDescriptor);
        IncrementalScoreDirectorFactory<Solution_, Score_> incrementalScoreDirectorFactory = this.buildIncrementalScoreDirectorFactory(solutionDescriptor);
        DroolsScoreDirectorFactory<Solution_, Score_> droolsScoreDirectorFactory = this.buildDroolsScoreDirectorFactory(classLoader, solutionDescriptor);
        this.checkMultipleScoreDirectorFactoryTypes(easyScoreDirectorFactory, constraintStreamScoreDirectorFactory, incrementalScoreDirectorFactory, droolsScoreDirectorFactory);
        if (easyScoreDirectorFactory != null) {
            scoreDirectorFactory = easyScoreDirectorFactory;
        } else if (constraintStreamScoreDirectorFactory != null) {
            scoreDirectorFactory = constraintStreamScoreDirectorFactory;
        } else if (incrementalScoreDirectorFactory != null) {
            scoreDirectorFactory = incrementalScoreDirectorFactory;
        } else if (droolsScoreDirectorFactory != null) {
            scoreDirectorFactory = droolsScoreDirectorFactory;
        } else {
            throw new IllegalArgumentException("The scoreDirectorFactory lacks a configuration for an easyScoreCalculatorClass, a constraintProviderClass, an incrementalScoreCalculatorClass or a droolsScoreDirectorFactory.");
        }
        return scoreDirectorFactory;
    }

    private void checkMultipleScoreDirectorFactoryTypes(EasyScoreDirectorFactory easyScoreDirectorFactory, ConstraintStreamScoreDirectorFactory constraintStreamScoreDirectorFactory, IncrementalScoreDirectorFactory incrementalScoreDirectorFactory, DroolsScoreDirectorFactory droolsScoreDirectorFactory) {
        if (Stream.of(easyScoreDirectorFactory, constraintStreamScoreDirectorFactory, incrementalScoreDirectorFactory, droolsScoreDirectorFactory).filter(Objects::nonNull).count() > 1L) {
            ArrayList<String> scoreDirectorFactoryPropertyList = new ArrayList<String>(4);
            if (easyScoreDirectorFactory != null) {
                scoreDirectorFactoryPropertyList.add("an easyScoreCalculatorClass (" + this.config.getEasyScoreCalculatorClass().getName() + ")");
            }
            if (constraintStreamScoreDirectorFactory != null) {
                scoreDirectorFactoryPropertyList.add("a constraintProviderClass (" + this.config.getConstraintProviderClass().getName() + ")");
            }
            if (incrementalScoreDirectorFactory != null) {
                scoreDirectorFactoryPropertyList.add("an incrementalScoreCalculatorClass (" + this.config.getIncrementalScoreCalculatorClass().getName() + ")");
            }
            if (droolsScoreDirectorFactory != null) {
                String abbreviatedScoreDrlList = ConfigUtils.abbreviate(this.config.getScoreDrlList());
                String abbreviatedScoreDrlFileList = this.config.getScoreDrlFileList() == null ? "" : ConfigUtils.abbreviate(this.config.getScoreDrlFileList().stream().map(File::getName).collect(Collectors.toList()));
                scoreDirectorFactoryPropertyList.add("a scoreDrlList (" + abbreviatedScoreDrlList + ") or a scoreDrlFileList (" + abbreviatedScoreDrlFileList + ")");
            }
            throw new IllegalArgumentException("The scoreDirectorFactory cannot have " + String.join((CharSequence)" and ", scoreDirectorFactoryPropertyList) + " together.");
        }
    }

    protected EasyScoreDirectorFactory<Solution_, Score_> buildEasyScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        if (this.config.getEasyScoreCalculatorClass() != null) {
            if (!EasyScoreCalculator.class.isAssignableFrom(this.config.getEasyScoreCalculatorClass())) {
                throw new IllegalArgumentException("The easyScoreCalculatorClass (" + this.config.getEasyScoreCalculatorClass() + ") does not implement " + EasyScoreCalculator.class.getSimpleName() + ".");
            }
            EasyScoreCalculator easyScoreCalculator = ConfigUtils.newInstance(this.config, "easyScoreCalculatorClass", this.config.getEasyScoreCalculatorClass());
            ConfigUtils.applyCustomProperties(easyScoreCalculator, "easyScoreCalculatorClass", this.config.getEasyScoreCalculatorCustomProperties(), "easyScoreCalculatorCustomProperties");
            return new EasyScoreDirectorFactory(solutionDescriptor, easyScoreCalculator);
        }
        if (this.config.getEasyScoreCalculatorCustomProperties() != null) {
            throw new IllegalStateException("If there is no easyScoreCalculatorClass (" + this.config.getEasyScoreCalculatorClass() + "), then there can be no easyScoreCalculatorCustomProperties (" + this.config.getEasyScoreCalculatorCustomProperties() + ") either.");
        }
        return null;
    }

    protected ConstraintStreamScoreDirectorFactory<Solution_, Score_> buildConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        if (this.config.getConstraintProviderClass() != null) {
            if (!ConstraintProvider.class.isAssignableFrom(this.config.getConstraintProviderClass())) {
                throw new IllegalArgumentException("The constraintProviderClass (" + this.config.getConstraintProviderClass() + ") does not implement " + ConstraintProvider.class.getSimpleName() + ".");
            }
            ConstraintProvider constraintProvider = ConfigUtils.newInstance(this.config, "constraintProviderClass", this.config.getConstraintProviderClass());
            ConfigUtils.applyCustomProperties(constraintProvider, "constraintProviderClass", this.config.getConstraintProviderCustomProperties(), "constraintProviderCustomProperties");
            ConstraintStreamImplType constraintStreamImplType_ = (ConstraintStreamImplType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.config.getConstraintStreamImplType()), (Object)((Object)ConstraintStreamImplType.DROOLS)));
            return new ConstraintStreamScoreDirectorFactory(solutionDescriptor, constraintProvider, constraintStreamImplType_);
        }
        if (this.config.getConstraintProviderCustomProperties() != null) {
            throw new IllegalStateException("If there is no constraintProviderClass (" + this.config.getConstraintProviderClass() + "), then there can be no constraintProviderCustomProperties (" + this.config.getConstraintProviderCustomProperties() + ") either.");
        }
        return null;
    }

    protected IncrementalScoreDirectorFactory<Solution_, Score_> buildIncrementalScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        if (this.config.getIncrementalScoreCalculatorClass() != null) {
            if (!IncrementalScoreCalculator.class.isAssignableFrom(this.config.getIncrementalScoreCalculatorClass())) {
                throw new IllegalArgumentException("The incrementalScoreCalculatorClass (" + this.config.getIncrementalScoreCalculatorClass() + ") does not implement " + IncrementalScoreCalculator.class.getSimpleName() + ".");
            }
            return new IncrementalScoreDirectorFactory(solutionDescriptor, this.config.getIncrementalScoreCalculatorClass(), this.config.getIncrementalScoreCalculatorCustomProperties());
        }
        if (this.config.getIncrementalScoreCalculatorCustomProperties() != null) {
            throw new IllegalStateException("If there is no incrementalScoreCalculatorClass (" + this.config.getIncrementalScoreCalculatorClass() + "), then there can be no incrementalScoreCalculatorCustomProperties (" + this.config.getIncrementalScoreCalculatorCustomProperties() + ") either.");
        }
        return null;
    }

    protected DroolsScoreDirectorFactory<Solution_, Score_> buildDroolsScoreDirectorFactory(ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor) {
        boolean generateDroolsTestOnError = Boolean.parseBoolean(System.getProperty(GENERATE_DROOLS_TEST_ON_ERROR_PROPERTY_NAME, "false"));
        if (ConfigUtils.isEmptyCollection(this.config.getScoreDrlList()) && ConfigUtils.isEmptyCollection(this.config.getScoreDrlFileList())) {
            if (this.config.getKieBaseConfigurationProperties() != null) {
                throw new IllegalArgumentException("If kieBaseConfigurationProperties (" + this.config.getKieBaseConfigurationProperties() + ") is not null, the scoreDrlList (" + this.config.getScoreDrlList() + ") or the scoreDrlFileList (" + this.config.getScoreDrlFileList() + ") must not be empty.");
            }
            if (generateDroolsTestOnError) {
                throw new IllegalArgumentException("If optaplanner.drools.generateTestOnError system property (" + generateDroolsTestOnError + ") is set, the scoreDrlList (" + this.config.getScoreDrlList() + ") or the scoreDrlFileList (" + this.config.getScoreDrlFileList() + ") must not be empty.");
            }
            return null;
        }
        KieHelper kieHelper = new KieHelper(new KnowledgeBuilderOption[]{PropertySpecificOption.ALLOWED}).setClassLoader(classLoader);
        if (!ConfigUtils.isEmptyCollection(this.config.getScoreDrlList())) {
            for (String scoreDrl : this.config.getScoreDrlList()) {
                if (scoreDrl == null) {
                    throw new IllegalArgumentException("The scoreDrl (" + scoreDrl + ") cannot be null.");
                }
                kieHelper.addResource((Resource)new ClassPathResource(scoreDrl, classLoader));
            }
        }
        if (!ConfigUtils.isEmptyCollection(this.config.getScoreDrlFileList())) {
            for (File scoreDrlFile : this.config.getScoreDrlFileList()) {
                kieHelper.addResource((Resource)new FileSystemResource(scoreDrlFile));
            }
        }
        try {
            KieBase kieBase = kieHelper.build(ExecutableModelProject.class, new KieBaseOption[0]);
            if (generateDroolsTestOnError) {
                return new TestGenDroolsScoreDirectorFactory(solutionDescriptor, kieBase, this.config.getScoreDrlList(), this.config.getScoreDrlFileList());
            }
            return new DroolsScoreDirectorFactory(solutionDescriptor, kieBase);
        }
        catch (Exception ex) {
            throw new IllegalStateException("There is an error in a scoreDrl or scoreDrlFile.", ex);
        }
    }

    protected KieBaseConfiguration buildKieBaseConfiguration(KieServices kieServices) {
        KieBaseConfiguration kieBaseConfiguration = kieServices.newKieBaseConfiguration();
        if (this.config.getKieBaseConfigurationProperties() != null) {
            for (Map.Entry<String, String> entry : this.config.getKieBaseConfigurationProperties().entrySet()) {
                kieBaseConfiguration.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return kieBaseConfiguration;
    }
}

