/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.consequences;

import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.BiConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.BiConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.BiConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.BiConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.BiConstraintLongConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.ConsequenceMatchWeightType;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.QuadConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.QuadConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.QuadConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.QuadConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.QuadConstraintLongConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.TriConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.TriConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.TriConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.TriConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.TriConstraintLongConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.UniConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.UniConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.UniConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.UniConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.UniConstraintLongConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.BiConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.QuadConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.TriConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.UniConstraintGraphNode;

public interface ConstraintConsequence<Node_ extends ConstraintGraphNode> {
    public static UniConstraintConsequence create(UniConstraintGraphNode terminalNode) {
        return new UniConstraintDefaultConsequence(terminalNode);
    }

    public static <A> UniConstraintConsequence create(UniConstraintGraphNode terminalNode, ToIntFunction<A> matchWeighter) {
        return new UniConstraintIntConsequence<A>(terminalNode, matchWeighter);
    }

    public static <A> UniConstraintConsequence create(UniConstraintGraphNode terminalNode, ToLongFunction<A> matchWeighter) {
        return new UniConstraintLongConsequence<A>(terminalNode, matchWeighter);
    }

    public static <A> UniConstraintConsequence create(UniConstraintGraphNode terminalNode, Function<A, BigDecimal> matchWeighter) {
        return new UniConstraintBigDecimalConsequence<A>(terminalNode, matchWeighter);
    }

    public static BiConstraintConsequence create(BiConstraintGraphNode terminalNode) {
        return new BiConstraintDefaultConsequence(terminalNode);
    }

    public static <A, B> BiConstraintConsequence create(BiConstraintGraphNode terminalNode, ToIntBiFunction<A, B> matchWeighter) {
        return new BiConstraintIntConsequence<A, B>(terminalNode, matchWeighter);
    }

    public static <A, B> BiConstraintConsequence create(BiConstraintGraphNode terminalNode, ToLongBiFunction<A, B> matchWeighter) {
        return new BiConstraintLongConsequence<A, B>(terminalNode, matchWeighter);
    }

    public static <A, B> BiConstraintConsequence create(BiConstraintGraphNode terminalNode, BiFunction<A, B, BigDecimal> matchWeighter) {
        return new BiConstraintBigDecimalConsequence<A, B>(terminalNode, matchWeighter);
    }

    public static TriConstraintConsequence create(TriConstraintGraphNode terminalNode) {
        return new TriConstraintDefaultConsequence(terminalNode);
    }

    public static <A, B, C> TriConstraintConsequence create(TriConstraintGraphNode terminalNode, ToIntTriFunction<A, B, C> matchWeighter) {
        return new TriConstraintIntConsequence<A, B, C>(terminalNode, matchWeighter);
    }

    public static <A, B, C> TriConstraintConsequence create(TriConstraintGraphNode terminalNode, ToLongTriFunction<A, B, C> matchWeighter) {
        return new TriConstraintLongConsequence<A, B, C>(terminalNode, matchWeighter);
    }

    public static <A, B, C> TriConstraintConsequence create(TriConstraintGraphNode terminalNode, TriFunction<A, B, C, BigDecimal> matchWeighter) {
        return new TriConstraintBigDecimalConsequence<A, B, C>(terminalNode, matchWeighter);
    }

    public static QuadConstraintConsequence create(QuadConstraintGraphNode terminalNode) {
        return new QuadConstraintDefaultConsequence(terminalNode);
    }

    public static <A, B, C, D> QuadConstraintConsequence create(QuadConstraintGraphNode terminalNode, ToIntQuadFunction<A, B, C, D> matchWeighter) {
        return new QuadConstraintIntConsequence<A, B, C, D>(terminalNode, matchWeighter);
    }

    public static <A, B, C, D> QuadConstraintConsequence create(QuadConstraintGraphNode terminalNode, ToLongQuadFunction<A, B, C, D> matchWeighter) {
        return new QuadConstraintLongConsequence<A, B, C, D>(terminalNode, matchWeighter);
    }

    public static <A, B, C, D> QuadConstraintConsequence create(QuadConstraintGraphNode terminalNode, QuadFunction<A, B, C, D, BigDecimal> matchWeighter) {
        return new QuadConstraintBigDecimalConsequence<A, B, C, D>(terminalNode, matchWeighter);
    }

    public Node_ getTerminalNode();

    public ConsequenceMatchWeightType getMatchWeightType();
}

