/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.drools.model.BetaIndex;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate2;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.FilteringBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.NoneBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.Mutator;

final class UniExistenceMutator<A, B>
implements Mutator {
    private final boolean shouldExist;
    private final Class<B> otherFactType;
    private final AbstractBiJoiner<A, B>[] joiners;

    public UniExistenceMutator(AbstractConstraintModelJoiningNode<B, AbstractBiJoiner<A, B>> node, boolean shouldExist) {
        this.shouldExist = shouldExist;
        this.otherFactType = node.getOtherFactType();
        this.joiners = (AbstractBiJoiner[])node.get().stream().toArray(AbstractBiJoiner[]::new);
    }

    private AbstractRuleAssembler applyJoiners(AbstractRuleAssembler ruleAssembler, AbstractBiJoiner<A, B> joiner, BiPredicate<A, B> predicate) {
        Function<A, Object> leftMapping;
        int currentMappingIndex;
        PatternDSL.PatternDef primaryPattern = ruleAssembler.getLastPrimaryPattern();
        Variable<B> toExist = ruleAssembler.createVariable(this.otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(ruleAssembler, existencePattern, predicate);
        }
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        Variable[] joinVars = new Variable[joinerTypes.length];
        int mappingIndex = 0;
        while (mappingIndex < joinerTypes.length) {
            currentMappingIndex = mappingIndex++;
            Variable joinVar = ruleAssembler.createVariable("joinVar");
            leftMapping = joiner.getLeftMapping(currentMappingIndex);
            primaryPattern = primaryPattern.bind(joinVar, leftMapping::apply);
            joinVars[currentMappingIndex] = joinVar;
        }
        mappingIndex = 0;
        while (mappingIndex < joinerTypes.length) {
            currentMappingIndex = mappingIndex++;
            JoinerType joinerType = joinerTypes[currentMappingIndex];
            leftMapping = joiner.getLeftMapping(currentMappingIndex);
            Function rightMapping = joiner.getRightMapping(currentMappingIndex);
            Predicate2 & Serializable joinPredicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(a, rightMapping.apply(b));
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)Mutator.getConstraintType(joinerType), (int)currentMappingIndex, rightMapping::apply, leftMapping::apply);
            existencePattern = existencePattern.expr("Join using joiner #" + currentMappingIndex + " in " + joiner, joinVars[currentMappingIndex], (Predicate2)joinPredicate, index);
        }
        return this.applyFilters(ruleAssembler, existencePattern, predicate);
    }

    private AbstractRuleAssembler applyFilters(AbstractRuleAssembler ruleAssembler, PatternDSL.PatternDef<B> existencePattern, BiPredicate<A, B> biPredicate) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = biPredicate == null ? existencePattern : existencePattern.expr("Filter using " + biPredicate, ruleAssembler.getVariable(0), (Predicate2 & Serializable)(b, a) -> biPredicate.test(a, b));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!this.shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        ruleAssembler.addDependentExpressionToLastPattern((ViewItem)existenceExpression);
        return ruleAssembler;
    }

    @Override
    public AbstractRuleAssembler apply(AbstractRuleAssembler ruleAssembler) {
        int indexOfFirstFilter = -1;
        AbstractBiJoiner<A, B> finalJoiner = null;
        BiPredicate<A, B> finalFilter = null;
        for (int i = 0; i < this.joiners.length; ++i) {
            boolean hasAFilter;
            AbstractBiJoiner<A, B> biJoiner = this.joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (biJoiner instanceof NoneBiJoiner && this.joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneBiJoiner.class + " must be the only joiner, got " + Arrays.toString(this.joiners) + " instead.");
            }
            if (!(biJoiner instanceof FilteringBiJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + biJoiner + ") must not follow a filtering joiner (" + this.joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? biJoiner : AbstractBiJoiner.merge(finalJoiner, biJoiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? biJoiner.getFilter() : finalFilter.and(biJoiner.getFilter());
        }
        return this.applyJoiners(ruleAssembler, finalJoiner, finalFilter);
    }
}

