/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.lang.reflect.Field;
import java.util.function.Function;

public interface LambdaPrinter {
    public String getLambdaFingerprint(Object var1);

    public static String print(Object lambda) {
        return Factory.get().getLambdaFingerprint(lambda);
    }

    public static class LambdaVisitor
    implements LambdaPrinter {
        private final Function<Object, String> introspector;

        public LambdaVisitor(Function<Object, String> introspector) {
            this.introspector = introspector;
        }

        @Override
        public String getLambdaFingerprint(Object lambda) {
            return this.introspector.apply(lambda);
        }
    }

    public static class DummyLambdaPrinter
    implements LambdaPrinter {
        @Override
        public String getLambdaFingerprint(Object lambda) {
            if (lambda.toString().equals("INSTANCE")) {
                return DummyLambdaPrinter.getExpressionHash(lambda);
            }
            return lambda.toString();
        }

        private static String getExpressionHash(Object lambda) {
            try {
                Field expressionHash = lambda.getClass().getDeclaredField("EXPRESSION_HASH");
                return (String)expressionHash.get(lambda);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory {
        public static LambdaPrinter get() {
            return LazyHolder.INSTANCE;
        }

        private static class LazyHolder {
            private static LambdaPrinter INSTANCE = LazyHolder.buildPrinter();

            private LazyHolder() {
            }

            private static LambdaPrinter buildPrinter() {
                try {
                    return new LambdaVisitor((Function)Class.forName("org.drools.mvel.asm.LambdaIntrospector").newInstance());
                }
                catch (Exception e) {
                    return new DummyLambdaPrinter();
                }
            }
        }
    }
}

