/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsAbstractTriConstraintStream;

public final class DroolsExistsTriConstraintStream<Solution_, A, B, C>
extends DroolsAbstractTriConstraintStream<Solution_, A, B, C> {
    private final DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent;
    private final TriLeftHandSide<A, B, C> leftHandSide;
    private final String streamName;

    public <D> DroolsExistsTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent, boolean shouldExist, Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        super(constraintFactory);
        this.parent = parent;
        this.leftHandSide = shouldExist ? parent.getLeftHandSide().andExists(otherClass, joiners) : parent.getLeftHandSide().andNotExists(otherClass, joiners);
        this.streamName = shouldExist ? "TriIfExists()" : "TriIfNotExists()";
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public TriLeftHandSide<A, B, C> getLeftHandSide() {
        return this.leftHandSide;
    }

    public String toString() {
        return this.streamName + " with " + this.getChildStreams().size() + " children";
    }
}

