/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.BiFunction;
import org.optaplanner.examples.common.experimental.api.IntervalCluster;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.IntervalTreeIterator;

public class IntervalClusterImpl<Interval_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>>
implements IntervalCluster<Interval_, Point_, Difference_> {
    IntervalSplitPoint<Interval_, Point_> startSplitPoint;
    IntervalSplitPoint<Interval_, Point_> endSplitPoint;
    int count;
    boolean hasOverlap;
    final NavigableSet<IntervalSplitPoint<Interval_, Point_>> splitPointSet;
    final BiFunction<Point_, Point_, Difference_> differenceFunction;

    public IntervalClusterImpl(NavigableSet<IntervalSplitPoint<Interval_, Point_>> splitPointSet, BiFunction<Point_, Point_, Difference_> differenceFunction, IntervalSplitPoint<Interval_, Point_> start) {
        if (start == null) {
            throw new IllegalArgumentException("start (" + start + ") is null");
        }
        if (differenceFunction == null) {
            throw new IllegalArgumentException("differenceFunction (" + differenceFunction + ") is null");
        }
        this.splitPointSet = splitPointSet;
        this.startSplitPoint = start;
        this.endSplitPoint = start;
        this.differenceFunction = differenceFunction;
        int activeIntervals = 0;
        this.count = 0;
        boolean anyOverlap = false;
        IntervalSplitPoint<Interval_, Point_> current = start;
        do {
            this.count += current.intervalsStartingAtSplitPointSet.size();
            if ((activeIntervals += current.intervalsStartingAtSplitPointSet.size() - current.intervalsEndingAtSplitPointSet.size()) > 1) {
                anyOverlap = true;
            }
            current = splitPointSet.higher(current);
        } while (activeIntervals > 0 && current != null);
        this.hasOverlap = anyOverlap;
        this.endSplitPoint = current != null ? splitPointSet.lower(current) : (IntervalSplitPoint)splitPointSet.last();
    }

    public IntervalClusterImpl(NavigableSet<IntervalSplitPoint<Interval_, Point_>> splitPointSet, BiFunction<Point_, Point_, Difference_> differenceFunction, IntervalSplitPoint<Interval_, Point_> start, IntervalSplitPoint<Interval_, Point_> end, int count, boolean hasOverlap) {
        this.splitPointSet = splitPointSet;
        this.startSplitPoint = start;
        this.endSplitPoint = end;
        this.differenceFunction = differenceFunction;
        this.count = count;
        this.hasOverlap = hasOverlap;
    }

    public IntervalSplitPoint<Interval_, Point_> getStartSplitPoint() {
        return this.startSplitPoint;
    }

    public IntervalSplitPoint<Interval_, Point_> getEndSplitPoint() {
        return this.endSplitPoint;
    }

    public void addInterval(Interval<Interval_, Point_> interval) {
        if (interval.getEndSplitPoint().compareTo(this.getStartSplitPoint()) > 0 && interval.getStartSplitPoint().compareTo(this.getEndSplitPoint()) < 0) {
            this.hasOverlap = true;
        }
        if (interval.getStartSplitPoint().compareTo(this.startSplitPoint) < 0) {
            this.startSplitPoint = this.splitPointSet.floor(interval.getStartSplitPoint());
        }
        if (interval.getEndSplitPoint().compareTo(this.endSplitPoint) > 0) {
            this.endSplitPoint = this.splitPointSet.ceiling(interval.getEndSplitPoint());
        }
        ++this.count;
    }

    public Iterable<IntervalClusterImpl<Interval_, Point_, Difference_>> removeInterval(Interval<Interval_, Point_> interval) {
        return () -> new Iterator<IntervalClusterImpl<Interval_, Point_, Difference_>>(){
            IntervalSplitPoint current;
            {
                this.current = this.getStart(IntervalClusterImpl.this.startSplitPoint);
            }

            private IntervalSplitPoint<Interval_, Point_> getStart(IntervalSplitPoint<Interval_, Point_> start) {
                while (start != null && start.isEmpty()) {
                    start = IntervalClusterImpl.this.splitPointSet.higher(start);
                }
                return start;
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.compareTo(IntervalClusterImpl.this.endSplitPoint) <= 0 && !IntervalClusterImpl.this.splitPointSet.isEmpty();
            }

            @Override
            public IntervalClusterImpl<Interval_, Point_, Difference_> next() {
                IntervalSplitPoint end;
                IntervalSplitPoint start = this.current;
                int activeIntervals = 0;
                IntervalClusterImpl.this.count = 0;
                boolean anyOverlap = false;
                do {
                    IntervalClusterImpl.this.count += this.current.intervalsStartingAtSplitPointSet.size();
                    if ((activeIntervals += this.current.intervalsStartingAtSplitPointSet.size() - this.current.intervalsEndingAtSplitPointSet.size()) > 1) {
                        anyOverlap = true;
                    }
                    this.current = IntervalClusterImpl.this.splitPointSet.higher(this.current);
                } while (activeIntervals > 0 && this.current != null);
                IntervalClusterImpl.this.hasOverlap = anyOverlap;
                if (this.current != null) {
                    end = IntervalClusterImpl.this.splitPointSet.lower(this.current);
                    this.current = this.getStart(this.current);
                } else {
                    end = (IntervalSplitPoint)IntervalClusterImpl.this.splitPointSet.last();
                }
                return new IntervalClusterImpl(IntervalClusterImpl.this.splitPointSet, IntervalClusterImpl.this.differenceFunction, start, end, IntervalClusterImpl.this.count, IntervalClusterImpl.this.hasOverlap);
            }
        };
    }

    public void mergeIntervalCluster(IntervalClusterImpl<Interval_, Point_, Difference_> laterIntervalCluster) {
        if (this.endSplitPoint.compareTo(laterIntervalCluster.startSplitPoint) > 0) {
            this.hasOverlap = true;
        }
        if (this.endSplitPoint.compareTo(laterIntervalCluster.endSplitPoint) < 0) {
            this.endSplitPoint = laterIntervalCluster.endSplitPoint;
        }
        this.count += laterIntervalCluster.count;
        this.hasOverlap |= laterIntervalCluster.hasOverlap;
    }

    @Override
    public Iterator<Interval_> iterator() {
        return new IntervalTreeIterator<Interval_, Point_>(this.splitPointSet.subSet(this.startSplitPoint, true, this.endSplitPoint, true));
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean hasOverlap() {
        return this.hasOverlap;
    }

    @Override
    public Point_ getStart() {
        return this.startSplitPoint.splitPoint;
    }

    @Override
    public Point_ getEnd() {
        return this.endSplitPoint.splitPoint;
    }

    @Override
    public Difference_ getLength() {
        return (Difference_)((Comparable)this.differenceFunction.apply(this.startSplitPoint.splitPoint, this.endSplitPoint.splitPoint));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalClusterImpl that = (IntervalClusterImpl)o;
        return this.startSplitPoint.equals(that.startSplitPoint) && this.endSplitPoint.equals(that.endSplitPoint);
    }

    public int hashCode() {
        return Objects.hash(this.startSplitPoint, this.endSplitPoint);
    }

    public String toString() {
        return "IntervalCluster{startSplitPoint=" + this.startSplitPoint + ", endSplitPoint=" + this.endSplitPoint + ", count=" + this.count + ", hasOverlap=" + this.hasOverlap + "}";
    }
}

