/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.score;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.calculator.ConstraintMatchAwareIncrementalScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.examples.machinereassignment.domain.MachineReassignment;
import org.optaplanner.examples.machinereassignment.domain.MrBalancePenalty;
import org.optaplanner.examples.machinereassignment.domain.MrGlobalPenaltyInfo;
import org.optaplanner.examples.machinereassignment.domain.MrLocation;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrNeighborhood;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.domain.MrService;

public class MachineReassignmentIncrementalScoreCalculator
implements ConstraintMatchAwareIncrementalScoreCalculator<MachineReassignment, HardSoftLongScore>,
IncrementalScoreCalculator<MachineReassignment, HardSoftLongScore> {
    protected static final String CONSTRAINT_PACKAGE = "org.optaplanner.examples.machinereassignment.solver";
    private MachineReassignment machineReassignment;
    private MrGlobalPenaltyInfo globalPenaltyInfo;
    private Map<MrService, MrServiceScorePart> serviceScorePartMap;
    private Map<Integer, Integer> movedProcessCountToServiceCount;
    private int serviceMoveCost;
    private Map<MrMachine, MrMachineScorePart> machineScorePartMap;
    private long hardScore;
    private long softScore;

    public void resetWorkingSolution(MachineReassignment machineReassignment) {
        this.machineReassignment = machineReassignment;
        this.hardScore = 0L;
        this.softScore = 0L;
        this.globalPenaltyInfo = machineReassignment.getGlobalPenaltyInfo();
        List<MrService> serviceList = machineReassignment.getServiceList();
        this.serviceScorePartMap = new HashMap<MrService, MrServiceScorePart>(serviceList.size());
        for (MrService service : serviceList) {
            this.serviceScorePartMap.put(service, new MrServiceScorePart(service));
        }
        this.movedProcessCountToServiceCount = new HashMap<Integer, Integer>(serviceList.size());
        this.movedProcessCountToServiceCount.put(0, serviceList.size());
        this.serviceMoveCost = 0;
        List<MrMachine> machineList = machineReassignment.getMachineList();
        this.machineScorePartMap = new HashMap<MrMachine, MrMachineScorePart>(machineList.size());
        for (MrMachine machine : machineList) {
            this.machineScorePartMap.put(machine, new MrMachineScorePart(machine));
        }
        for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
            MrMachine originalMachine = processAssignment.getOriginalMachine();
            if (originalMachine == null) continue;
            this.machineScorePartMap.get(originalMachine).initOriginalProcessAssignment(processAssignment);
        }
        for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
            this.insert(processAssignment);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((MrProcessAssignment)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((MrProcessAssignment)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((MrProcessAssignment)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((MrProcessAssignment)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(MrProcessAssignment processAssignment) {
        MrMachine machine = processAssignment.getMachine();
        if (machine != null) {
            MrServiceScorePart serviceScorePart = this.serviceScorePartMap.get(processAssignment.getService());
            serviceScorePart.addProcessAssignment(processAssignment);
            MrMachineScorePart machineScorePart = this.machineScorePartMap.get(machine);
            machineScorePart.addProcessAssignment(processAssignment);
        }
    }

    private void retract(MrProcessAssignment processAssignment) {
        MrMachine machine = processAssignment.getMachine();
        if (machine != null) {
            MrServiceScorePart serviceScorePart = this.serviceScorePartMap.get(processAssignment.getService());
            serviceScorePart.removeProcessAssignment(processAssignment);
            MrMachineScorePart machineScorePart = this.machineScorePartMap.get(machine);
            machineScorePart.removeProcessAssignment(processAssignment);
        }
    }

    public HardSoftLongScore calculateScore() {
        return HardSoftLongScore.of((long)this.hardScore, (long)this.softScore);
    }

    public void resetWorkingSolution(MachineReassignment workingSolution, boolean constraintMatchEnabled) {
        this.resetWorkingSolution(workingSolution);
    }

    public Collection<ConstraintMatchTotal<HardSoftLongScore>> getConstraintMatchTotals() {
        DefaultConstraintMatchTotal maximumCapacityMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "maximumCapacity", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal serviceConflictMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "serviceConflict", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal serviceLocationSpreadMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "serviceLocationSpread", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal serviceDependencyMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "serviceDependency", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal loadCostMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "loadCost", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal balanceCostMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "balanceCost", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal processMoveCostMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "processMoveCost", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal serviceMoveCostMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "serviceMoveCost", (Score)HardSoftLongScore.ZERO);
        DefaultConstraintMatchTotal machineMoveCostMatchTotal = new DefaultConstraintMatchTotal(CONSTRAINT_PACKAGE, "machineMoveCost", (Score)HardSoftLongScore.ZERO);
        for (MrServiceScorePart serviceScorePart : this.serviceScorePartMap.values()) {
            MrService service = serviceScorePart.service;
            if (service.getLocationSpread() <= serviceScorePart.locationBag.size()) continue;
            serviceLocationSpreadMatchTotal.addConstraintMatch(Arrays.asList(service), (Score)HardSoftLongScore.of((long)(-(service.getLocationSpread() - serviceScorePart.locationBag.size())), (long)0L));
        }
        for (MrMachineScorePart machineScorePart : this.machineScorePartMap.values()) {
            for (MrMachineCapacityScorePart mrMachineCapacityScorePart : machineScorePart.machineCapacityScorePartList) {
                if (mrMachineCapacityScorePart.maximumAvailable < 0L) {
                    maximumCapacityMatchTotal.addConstraintMatch(Arrays.asList(mrMachineCapacityScorePart.machineCapacity), (Score)HardSoftLongScore.of((long)mrMachineCapacityScorePart.maximumAvailable, (long)0L));
                }
                if (mrMachineCapacityScorePart.safetyAvailable >= 0L) continue;
                loadCostMatchTotal.addConstraintMatch(Arrays.asList(mrMachineCapacityScorePart.machineCapacity), (Score)HardSoftLongScore.of((long)0L, (long)(mrMachineCapacityScorePart.safetyAvailable * (long)mrMachineCapacityScorePart.machineCapacity.getResource().getLoadCostWeight())));
            }
            for (MrBalancePenalty mrBalancePenalty : this.machineReassignment.getBalancePenaltyList()) {
                long minimumTargetAvailable;
                long originAvailable = machineScorePart.machineCapacityScorePartList.get(mrBalancePenalty.getOriginResource().getIndex()).getBalanceAvailable();
                long targetAvailable = machineScorePart.machineCapacityScorePartList.get(mrBalancePenalty.getTargetResource().getIndex()).getBalanceAvailable();
                if (originAvailable <= 0L || targetAvailable >= (minimumTargetAvailable = originAvailable * (long)mrBalancePenalty.getMultiplicand())) continue;
                balanceCostMatchTotal.addConstraintMatch(Arrays.asList(machineScorePart.machine, mrBalancePenalty), (Score)HardSoftLongScore.of((long)0L, (long)(-(minimumTargetAvailable - targetAvailable) * (long)mrBalancePenalty.getWeight())));
            }
            for (Map.Entry entry : machineScorePart.serviceBag.entrySet()) {
                Integer serviceProcessCount = (Integer)entry.getValue();
                if (serviceProcessCount <= 1) continue;
                serviceConflictMatchTotal.addConstraintMatch(Arrays.asList(machineScorePart.machine, entry.getKey()), (Score)HardSoftLongScore.of((long)(-(serviceProcessCount - 1)), (long)0L));
            }
        }
        for (MrProcessAssignment processAssignment : this.machineReassignment.getProcessAssignmentList()) {
            for (MrService mrService : processAssignment.getService().getToDependencyServiceList()) {
                MrServiceScorePart serviceScorePart = this.serviceScorePartMap.get(mrService);
                int toDependencyNeighborhoodProcessCount = serviceScorePart.neighborhoodBag.getOrDefault(processAssignment.getNeighborhood(), 0);
                if (toDependencyNeighborhoodProcessCount != 0) continue;
                serviceDependencyMatchTotal.addConstraintMatch(Arrays.asList(processAssignment, mrService), (Score)HardSoftLongScore.of((long)-1L, (long)0L));
            }
            if (!processAssignment.isMoved()) continue;
            processMoveCostMatchTotal.addConstraintMatch(Arrays.asList(processAssignment), (Score)HardSoftLongScore.of((long)0L, (long)(-((long)processAssignment.getProcessMoveCost() * (long)this.globalPenaltyInfo.getProcessMoveCostWeight()))));
            machineMoveCostMatchTotal.addConstraintMatch(Arrays.asList(processAssignment), (Score)HardSoftLongScore.of((long)0L, (long)(-((long)processAssignment.getMachineMoveCost() * (long)this.globalPenaltyInfo.getMachineMoveCostWeight()))));
        }
        for (int i = 0; i < this.serviceMoveCost; ++i) {
            serviceMoveCostMatchTotal.addConstraintMatch(Arrays.asList(i), (Score)HardSoftLongScore.of((long)0L, (long)(-this.globalPenaltyInfo.getServiceMoveCostWeight())));
        }
        ArrayList<ConstraintMatchTotal<HardSoftLongScore>> constraintMatchTotalList = new ArrayList<ConstraintMatchTotal<HardSoftLongScore>>(4);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)maximumCapacityMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)serviceConflictMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)serviceLocationSpreadMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)serviceDependencyMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)loadCostMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)balanceCostMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)processMoveCostMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)serviceMoveCostMatchTotal);
        constraintMatchTotalList.add((ConstraintMatchTotal<HardSoftLongScore>)machineMoveCostMatchTotal);
        return constraintMatchTotalList;
    }

    public Map<Object, Indictment<HardSoftLongScore>> getIndictmentMap() {
        return null;
    }

    private class MrMachineCapacityScorePart {
        private final MrMachineCapacity machineCapacity;
        private long maximumAvailable;
        private long safetyAvailable;
        private long balanceAvailable;

        private MrMachineCapacityScorePart(MrMachineCapacity machineCapacity) {
            this.machineCapacity = machineCapacity;
            this.maximumAvailable = machineCapacity.getMaximumCapacity();
            this.safetyAvailable = machineCapacity.getSafetyCapacity();
            this.balanceAvailable = machineCapacity.getMaximumCapacity();
        }

        private void initOriginalProcessAssignment(MrProcessAssignment processAssignment) {
            if (this.machineCapacity.isTransientlyConsumed()) {
                long processUsage = processAssignment.getProcess().getProcessRequirement(this.machineCapacity.getResource()).getUsage();
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= Math.min(this.maximumAvailable, 0L);
                this.maximumAvailable -= processUsage;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += Math.min(this.maximumAvailable, 0L);
            }
        }

        private void addProcessAssignment(MrProcessAssignment processAssignment) {
            MrResource resource = this.machineCapacity.getResource();
            long processUsage = processAssignment.getUsage(resource);
            if (!this.machineCapacity.isTransientlyConsumed() || processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= Math.min(this.maximumAvailable, 0L);
                this.maximumAvailable -= processUsage;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += Math.min(this.maximumAvailable, 0L);
            }
            MachineReassignmentIncrementalScoreCalculator.this.softScore -= Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.safetyAvailable -= processUsage;
            MachineReassignmentIncrementalScoreCalculator.this.softScore += Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.balanceAvailable -= processUsage;
        }

        private void removeProcessAssignment(MrProcessAssignment processAssignment) {
            MrResource resource = this.machineCapacity.getResource();
            long processUsage = processAssignment.getUsage(resource);
            if (!this.machineCapacity.isTransientlyConsumed() || processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= Math.min(this.maximumAvailable, 0L);
                this.maximumAvailable += processUsage;
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += Math.min(this.maximumAvailable, 0L);
            }
            MachineReassignmentIncrementalScoreCalculator.this.softScore -= Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.safetyAvailable += processUsage;
            MachineReassignmentIncrementalScoreCalculator.this.softScore += Math.min(this.safetyAvailable, 0L) * (long)resource.getLoadCostWeight();
            this.balanceAvailable += processUsage;
        }

        public long getBalanceAvailable() {
            return this.balanceAvailable;
        }
    }

    private class MrMachineScorePart {
        private final MrMachine machine;
        private final List<MrMachineCapacityScorePart> machineCapacityScorePartList;
        private Map<MrService, Integer> serviceBag;

        public MrMachineScorePart(MrMachine machine) {
            this.machine = machine;
            List<MrMachineCapacity> machineCapacityList = machine.getMachineCapacityList();
            this.machineCapacityScorePartList = new ArrayList<MrMachineCapacityScorePart>(machineCapacityList.size());
            for (MrMachineCapacity machineCapacity : machineCapacityList) {
                this.machineCapacityScorePartList.add(new MrMachineCapacityScorePart(machineCapacity));
            }
            this.serviceBag = new HashMap<MrService, Integer>(10);
            this.doBalancePenaltyCosts();
        }

        public void initOriginalProcessAssignment(MrProcessAssignment processAssignment) {
            for (MrMachineCapacityScorePart machineCapacityScorePart : this.machineCapacityScorePartList) {
                machineCapacityScorePart.initOriginalProcessAssignment(processAssignment);
            }
        }

        private void addProcessAssignment(MrProcessAssignment processAssignment) {
            this.undoBalancePenaltyCosts();
            for (MrMachineCapacityScorePart machineCapacityScorePart : this.machineCapacityScorePartList) {
                machineCapacityScorePart.addProcessAssignment(processAssignment);
            }
            MrService service = processAssignment.getService();
            int serviceProcessCount = this.serviceBag.computeIfAbsent(service, k -> 0);
            if (serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += (long)(serviceProcessCount - 1);
            }
            if (++serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= (long)(serviceProcessCount - 1);
            }
            if (serviceProcessCount == 0) {
                this.serviceBag.remove(service);
            } else {
                this.serviceBag.put(service, serviceProcessCount);
            }
            this.doBalancePenaltyCosts();
            if (processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.softScore -= (long)processAssignment.getProcessMoveCost() * (long)MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getProcessMoveCostWeight();
                MachineReassignmentIncrementalScoreCalculator.this.softScore -= (long)processAssignment.getMachineMoveCost() * (long)MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getMachineMoveCostWeight();
            }
        }

        private void removeProcessAssignment(MrProcessAssignment processAssignment) {
            this.undoBalancePenaltyCosts();
            for (MrMachineCapacityScorePart machineCapacityScorePart : this.machineCapacityScorePartList) {
                machineCapacityScorePart.removeProcessAssignment(processAssignment);
            }
            MrService service = processAssignment.getService();
            int serviceProcessCount = this.serviceBag.computeIfAbsent(service, k -> 0);
            if (serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore += (long)(serviceProcessCount - 1);
            }
            if (--serviceProcessCount > 1) {
                MachineReassignmentIncrementalScoreCalculator.this.hardScore -= (long)(serviceProcessCount - 1);
            }
            if (serviceProcessCount == 0) {
                this.serviceBag.remove(service);
            } else {
                this.serviceBag.put(service, serviceProcessCount);
            }
            this.doBalancePenaltyCosts();
            if (processAssignment.isMoved()) {
                MachineReassignmentIncrementalScoreCalculator.this.softScore += (long)processAssignment.getProcessMoveCost() * (long)MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getProcessMoveCostWeight();
                MachineReassignmentIncrementalScoreCalculator.this.softScore += (long)processAssignment.getMachineMoveCost() * (long)MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getMachineMoveCostWeight();
            }
        }

        private void doBalancePenaltyCosts() {
            for (MrBalancePenalty balancePenalty : MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getBalancePenaltyList()) {
                long minimumTargetAvailable;
                long originAvailable = this.machineCapacityScorePartList.get(balancePenalty.getOriginResource().getIndex()).getBalanceAvailable();
                long targetAvailable = this.machineCapacityScorePartList.get(balancePenalty.getTargetResource().getIndex()).getBalanceAvailable();
                if (originAvailable <= 0L || targetAvailable >= (minimumTargetAvailable = originAvailable * (long)balancePenalty.getMultiplicand())) continue;
                MachineReassignmentIncrementalScoreCalculator.this.softScore -= (minimumTargetAvailable - targetAvailable) * (long)balancePenalty.getWeight();
            }
        }

        private void undoBalancePenaltyCosts() {
            for (MrBalancePenalty balancePenalty : MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getBalancePenaltyList()) {
                long minimumTargetAvailable;
                long originAvailable = this.machineCapacityScorePartList.get(balancePenalty.getOriginResource().getIndex()).getBalanceAvailable();
                long targetAvailable = this.machineCapacityScorePartList.get(balancePenalty.getTargetResource().getIndex()).getBalanceAvailable();
                if (originAvailable <= 0L || targetAvailable >= (minimumTargetAvailable = originAvailable * (long)balancePenalty.getMultiplicand())) continue;
                MachineReassignmentIncrementalScoreCalculator.this.softScore += (minimumTargetAvailable - targetAvailable) * (long)balancePenalty.getWeight();
            }
        }
    }

    private class MrServiceScorePart {
        private final MrService service;
        private Map<MrLocation, Integer> locationBag;
        private Map<MrNeighborhood, Integer> neighborhoodBag;
        private int movedProcessCount;

        private MrServiceScorePart(MrService service) {
            this.service = service;
            this.locationBag = new HashMap<MrLocation, Integer>(MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getLocationList().size());
            MachineReassignmentIncrementalScoreCalculator.this.hardScore -= (long)service.getLocationSpread();
            List<MrNeighborhood> neighborhoodList = MachineReassignmentIncrementalScoreCalculator.this.machineReassignment.getNeighborhoodList();
            this.neighborhoodBag = new HashMap<MrNeighborhood, Integer>(neighborhoodList.size());
            for (MrNeighborhood neighborhood : neighborhoodList) {
                this.neighborhoodBag.put(neighborhood, 0);
            }
            this.movedProcessCount = 0;
        }

        private void addProcessAssignment(MrProcessAssignment processAssignment) {
            MrLocation location = processAssignment.getLocation();
            Integer locationProcessCount = this.locationBag.get(location);
            if (locationProcessCount == null) {
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore += (long)(this.service.getLocationSpread() - this.locationBag.size());
                }
                this.locationBag.put(location, 1);
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore -= (long)(this.service.getLocationSpread() - this.locationBag.size());
                }
            } else {
                this.locationBag.put(location, locationProcessCount + 1);
            }
            MrNeighborhood neighborhood = processAssignment.getNeighborhood();
            int neighborhoodProcessCount = this.neighborhoodBag.get(neighborhood) + 1;
            this.neighborhoodBag.put(neighborhood, neighborhoodProcessCount);
            for (MrService toDependencyService : this.service.getToDependencyServiceList()) {
                int toDependencyNeighborhoodProcessCount = MachineReassignmentIncrementalScoreCalculator.this.serviceScorePartMap.get((Object)toDependencyService).neighborhoodBag.get(neighborhood);
                if (toDependencyNeighborhoodProcessCount != 0) continue;
                --MachineReassignmentIncrementalScoreCalculator.this.hardScore;
            }
            if (neighborhoodProcessCount == 1) {
                for (MrService fromDependencyService : this.service.getFromDependencyServiceList()) {
                    int fromDependencyNeighborhoodProcessCount = MachineReassignmentIncrementalScoreCalculator.this.serviceScorePartMap.get((Object)fromDependencyService).neighborhoodBag.get(neighborhood);
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore += (long)fromDependencyNeighborhoodProcessCount;
                }
            }
            if (processAssignment.isMoved()) {
                int oldServiceCount = MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, oldServiceCount - 1);
                if (MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost == this.movedProcessCount) {
                    ++MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost;
                    MachineReassignmentIncrementalScoreCalculator.this.softScore -= (long)MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getServiceMoveCostWeight();
                }
                ++this.movedProcessCount;
                Integer newServiceCount = MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                if (newServiceCount == null) {
                    newServiceCount = 0;
                }
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, newServiceCount + 1);
            }
        }

        private void removeProcessAssignment(MrProcessAssignment processAssignment) {
            MrLocation location = processAssignment.getLocation();
            int locationProcessCount = this.locationBag.get(location);
            if (locationProcessCount == 1) {
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore += (long)(this.service.getLocationSpread() - this.locationBag.size());
                }
                this.locationBag.remove(location);
                if (this.service.getLocationSpread() > this.locationBag.size()) {
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore -= (long)(this.service.getLocationSpread() - this.locationBag.size());
                }
            } else {
                this.locationBag.put(location, locationProcessCount - 1);
            }
            MrNeighborhood neighborhood = processAssignment.getNeighborhood();
            int neighborhoodProcessCount = this.neighborhoodBag.get(neighborhood) - 1;
            this.neighborhoodBag.put(neighborhood, neighborhoodProcessCount);
            for (MrService toDependencyService : this.service.getToDependencyServiceList()) {
                int toDependencyNeighborhoodProcessCount = MachineReassignmentIncrementalScoreCalculator.this.serviceScorePartMap.get((Object)toDependencyService).neighborhoodBag.get(neighborhood);
                if (toDependencyNeighborhoodProcessCount != 0) continue;
                ++MachineReassignmentIncrementalScoreCalculator.this.hardScore;
            }
            if (neighborhoodProcessCount == 0) {
                for (MrService fromDependencyService : this.service.getFromDependencyServiceList()) {
                    int fromDependencyNeighborhoodProcessCount = MachineReassignmentIncrementalScoreCalculator.this.serviceScorePartMap.get((Object)fromDependencyService).neighborhoodBag.get(neighborhood);
                    MachineReassignmentIncrementalScoreCalculator.this.hardScore -= (long)fromDependencyNeighborhoodProcessCount;
                }
            }
            if (processAssignment.isMoved()) {
                int oldServiceCount = MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, oldServiceCount - 1);
                if (oldServiceCount == 1 && MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost == this.movedProcessCount) {
                    --MachineReassignmentIncrementalScoreCalculator.this.serviceMoveCost;
                    MachineReassignmentIncrementalScoreCalculator.this.softScore += (long)MachineReassignmentIncrementalScoreCalculator.this.globalPenaltyInfo.getServiceMoveCostWeight();
                }
                --this.movedProcessCount;
                int newServiceCount = MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.get(this.movedProcessCount);
                MachineReassignmentIncrementalScoreCalculator.this.movedProcessCountToServiceCount.put(this.movedProcessCount, newServiceCount + 1);
            }
        }
    }
}

