/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.util.MethodUtils;
import org.drools.core.util.StreamUtils;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvelcompiler.RHSPhase;
import org.drools.mvelcompiler.ast.MethodCallExprT;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.context.DeclaredFunction;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.drools.mvelcompiler.util.TypeUtils;

public class MethodCallExprVisitor
implements DrlGenericVisitor<TypedExpression, RHSPhase.Context> {
    final RHSPhase parentVisitor;
    final MvelCompilerContext mvelCompilerContext;

    public MethodCallExprVisitor(RHSPhase parentVisitor, MvelCompilerContext mvelCompilerContext) {
        this.parentVisitor = parentVisitor;
        this.mvelCompilerContext = mvelCompilerContext;
    }

    public TypedExpression defaultMethod(Node n, RHSPhase.Context context) {
        return (TypedExpression)n.accept((GenericVisitor)this.parentVisitor, (Object)context);
    }

    public TypedExpression visit(MethodCallExpr n, RHSPhase.Context arg) {
        Optional<TypedExpression> scope = n.getScope().map(s -> (TypedExpression)s.accept((GenericVisitor)this, (Object)arg));
        TypedExpression name = (TypedExpression)n.getName().accept((GenericVisitor)this, (Object)new RHSPhase.Context(scope.orElse(null)));
        ArrayList<TypedExpression> arguments = new ArrayList<TypedExpression>(n.getArguments().size());
        for (Expression child : n.getArguments()) {
            TypedExpression a = (TypedExpression)child.accept((GenericVisitor)this, (Object)arg);
            arguments.add(a);
        }
        Class[] argumentsTypes = this.parametersType(arguments);
        return this.parseMethodFromDeclaredFunction(n, arguments).orElseGet(() -> this.parseMethod(n, scope, name, arguments, argumentsTypes));
    }

    private Optional<TypedExpression> parseMethodFromDeclaredFunction(MethodCallExpr n, List<TypedExpression> arguments) {
        Optional<DeclaredFunction> optDeclaredFunction = this.mvelCompilerContext.findDeclaredFunction(n.getNameAsString());
        if (!optDeclaredFunction.isPresent()) {
            return Optional.empty();
        }
        DeclaredFunction declaredFunction = optDeclaredFunction.get();
        Optional<Class<?>> methodReturnType = declaredFunction.findReturnType();
        List<Class<?>> actualArgumentTypes = declaredFunction.findArgumentsType();
        return methodReturnType.map(t -> new MethodCallExprT(n.getName().asString(), Optional.empty(), arguments, actualArgumentTypes, Optional.of(t)));
    }

    private MethodCallExprT parseMethod(MethodCallExpr n, Optional<TypedExpression> scope, TypedExpression name, List<TypedExpression> arguments, Class<?>[] argumentsType) {
        Optional<Method> method = scope.flatMap(TypedExpression::getType).map(TypeUtils::classFromType).map(scopeClazz -> MethodUtils.findMethod((Class)scopeClazz, (String)n.getNameAsString(), (Class[])argumentsType));
        if (!method.isPresent() && (method = this.mvelCompilerContext.getRootPattern().map(scopeClazz -> MethodUtils.findMethod((Class)scopeClazz, (String)n.getNameAsString(), (Class[])argumentsType))).isPresent()) {
            scope = this.mvelCompilerContext.createRootTypePrefix();
        }
        if (!method.isPresent()) {
            method = this.mvelCompilerContext.findStaticMethod(n.getNameAsString());
        }
        Optional<Method> finalMethod = method;
        Optional methodReturnType = name.getType().map(Optional::of).orElseGet(() -> finalMethod.map(Method::getReturnType));
        List<Class<?>> actualArgumentType = StreamUtils.optionalToStream(method).flatMap(m -> Arrays.stream(m.getParameterTypes())).collect(Collectors.toList());
        return new MethodCallExprT(n.getName().asString(), scope, arguments, actualArgumentType, methodReturnType);
    }

    private Class<?>[] parametersType(List<TypedExpression> arguments) {
        return (Class[])arguments.stream().map(TypedExpression::getType).filter(Optional::isPresent).map(Optional::get).map(TypeUtils::classFromType).toArray(Class[]::new);
    }
}

