/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.drools.mvel.parser.printer.PrintUtil;
import org.drools.mvelcompiler.CompiledResult;

public class CompiledExpressionResult
implements CompiledResult {
    private Expression expression;
    private Optional<Type> type;
    private Set<String> usedBindings = new HashSet<String>();

    public CompiledExpressionResult(Expression expression, Optional<Type> type) {
        this.expression = expression;
        this.type = type;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Optional<Type> getType() {
        return this.type;
    }

    public String resultAsString() {
        return PrintUtil.printConstraint((Node)this.expression);
    }

    @Override
    public BlockStmt statementResults() {
        return new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ExpressionStmt(this.expression)}));
    }

    @Override
    public Set<String> getUsedBindings() {
        return this.usedBindings;
    }

    public CompiledExpressionResult setUsedBindings(Set<String> usedBindings) {
        this.usedBindings = usedBindings;
        return this;
    }
}

