/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Arrays;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.score.director.stream.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirector;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.test.api.score.stream.MultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintAssertion;

public final class DefaultMultiConstraintVerification<Solution_, Score_ extends Score<Score_>>
implements MultiConstraintVerification<Solution_> {
    private final AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;
    private final ConstraintProvider constraintProvider;

    protected DefaultMultiConstraintVerification(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, ConstraintProvider constraintProvider) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.constraintProvider = constraintProvider;
    }

    @Override
    public final DefaultMultiConstraintAssertion<Solution_, Score_> given(Object ... facts) {
        try (ConstraintSession constraintSession = this.scoreDirectorFactory.newConstraintStreamingSession(true, null);){
            Arrays.stream(facts).forEach(arg_0 -> ((ConstraintSession)constraintSession).insert(arg_0));
            DefaultMultiConstraintAssertion defaultMultiConstraintAssertion = new DefaultMultiConstraintAssertion(this.constraintProvider, constraintSession.calculateScore(0), constraintSession.getConstraintMatchTotalMap(), constraintSession.getIndictmentMap());
            return defaultMultiConstraintAssertion;
        }
    }

    @Override
    public final DefaultMultiConstraintAssertion<Solution_, Score_> givenSolution(Solution_ solution) {
        try (ConstraintStreamScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(Objects.requireNonNull(solution));
            DefaultMultiConstraintAssertion defaultMultiConstraintAssertion = new DefaultMultiConstraintAssertion(this.constraintProvider, scoreDirector.calculateScore(), scoreDirector.getConstraintMatchTotalMap(), scoreDirector.getIndictmentMap());
            return defaultMultiConstraintAssertion;
        }
    }
}

