/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.domain.valuerange;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.bigdecimal.BigDecimalValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.biginteger.BigIntegerValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.primboolean.BooleanValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.primdouble.DoubleValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.primint.IntValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.primlong.LongValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.temporal.TemporalValueRange;

public final class ValueRangeFactory {
    public static CountableValueRange<Boolean> createBooleanValueRange() {
        return new BooleanValueRange();
    }

    public static CountableValueRange<Integer> createIntValueRange(int from, int to) {
        return new IntValueRange(from, to);
    }

    public static CountableValueRange<Integer> createIntValueRange(int from, int to, int incrementUnit) {
        return new IntValueRange(from, to, incrementUnit);
    }

    public static CountableValueRange<Long> createLongValueRange(long from, long to) {
        return new LongValueRange(from, to);
    }

    public static CountableValueRange<Long> createLongValueRange(long from, long to, long incrementUnit) {
        return new LongValueRange(from, to, incrementUnit);
    }

    public static ValueRange<Double> createDoubleValueRange(double from, double to) {
        return new DoubleValueRange(from, to);
    }

    public static CountableValueRange<BigInteger> createBigIntegerValueRange(BigInteger from, BigInteger to) {
        return new BigIntegerValueRange(from, to);
    }

    public static CountableValueRange<BigInteger> createBigIntegerValueRange(BigInteger from, BigInteger to, BigInteger incrementUnit) {
        return new BigIntegerValueRange(from, to, incrementUnit);
    }

    public static CountableValueRange<BigDecimal> createBigDecimalValueRange(BigDecimal from, BigDecimal to) {
        return new BigDecimalValueRange(from, to);
    }

    public static CountableValueRange<BigDecimal> createBigDecimalValueRange(BigDecimal from, BigDecimal to, BigDecimal incrementUnit) {
        return new BigDecimalValueRange(from, to, incrementUnit);
    }

    public static CountableValueRange<LocalDate> createLocalDateValueRange(LocalDate from, LocalDate to, long incrementUnitAmount, TemporalUnit incrementUnitType) {
        return ValueRangeFactory.createTemporalValueRange(from, to, incrementUnitAmount, incrementUnitType);
    }

    public static CountableValueRange<LocalTime> createLocalTimeValueRange(LocalTime from, LocalTime to, long incrementUnitAmount, TemporalUnit incrementUnitType) {
        return ValueRangeFactory.createTemporalValueRange(from, to, incrementUnitAmount, incrementUnitType);
    }

    public static CountableValueRange<LocalDateTime> createLocalDateTimeValueRange(LocalDateTime from, LocalDateTime to, long incrementUnitAmount, TemporalUnit incrementUnitType) {
        return ValueRangeFactory.createTemporalValueRange(from, to, incrementUnitAmount, incrementUnitType);
    }

    public static <Temporal_ extends Temporal & Comparable<? super Temporal_>> CountableValueRange<Temporal_> createTemporalValueRange(Temporal_ from, Temporal_ to, long incrementUnitAmount, TemporalUnit incrementUnitType) {
        return new TemporalValueRange<Temporal_>(from, to, incrementUnitAmount, incrementUnitType);
    }
}

