/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simple;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScoreHolder;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public final class SimpleScoreHolderImpl
extends AbstractScoreHolder<SimpleScore>
implements SimpleScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.IntMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.IntMatchExecutor>();
    protected int score;

    public SimpleScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, SimpleScore.ZERO);
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void configureConstraintWeight(Rule rule, SimpleScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        AbstractScoreHolder.IntMatchExecutor matchExecutor = constraintWeight.equals(SimpleScore.ZERO) ? (kcontext, matchWeight, justifications) -> {} : (kcontext, matchWeight, justifications) -> this.addConstraintMatch(kcontext, constraintWeight.getScore() * matchWeight, justifications);
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
    }

    @Override
    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1);
    }

    @Override
    public void penalize(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    @Override
    public void reward(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, Object ... justifications) {
        this.impactScore(kcontext, 1, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier, Object ... justifications) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.IntMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier, Object ... justifications) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a long weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeLong() to penalize().");
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier, Object ... justifications) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a BigDecimal weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeBigDecimal() to penalize().");
    }

    @Override
    public void addConstraintMatch(RuleContext kcontext, int weight) {
        this.addConstraintMatch(kcontext, weight, EMPTY_OBJECT_ARRAY);
    }

    private void addConstraintMatch(RuleContext kcontext, int weight, Object ... justifications) {
        this.score += weight;
        this.registerConstraintMatch(kcontext, () -> this.score -= weight, () -> SimpleScore.of(weight), justifications);
    }

    @Override
    public SimpleScore extractScore(int initScore) {
        return SimpleScore.ofUninitialized(initScore, this.score);
    }
}

