/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simplelong;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScoreHolder;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public final class SimpleLongScoreHolderImpl
extends AbstractScoreHolder<SimpleLongScore>
implements SimpleLongScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.LongMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.LongMatchExecutor>();
    protected long score;

    public SimpleLongScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, SimpleLongScore.ZERO);
    }

    public long getScore() {
        return this.score;
    }

    @Override
    public void configureConstraintWeight(Rule rule, SimpleLongScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        AbstractScoreHolder.LongMatchExecutor matchExecutor = constraintWeight.equals(SimpleLongScore.ZERO) ? (kcontext, matchWeight, justifications) -> {} : (kcontext, matchWeight, justifications) -> this.addConstraintMatch(kcontext, constraintWeight.getScore() * matchWeight, justifications);
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
    }

    @Override
    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1L);
    }

    @Override
    public void penalize(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1L);
    }

    @Override
    public void reward(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, Object ... justifications) {
        this.impactScore(kcontext, 1L, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier, Object ... justifications) {
        this.impactScore(kcontext, (long)weightMultiplier, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier, Object ... justifications) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.LongMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier, Object ... justifications) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a BigDecimal weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeBigDecimal() to penalizeLong().");
    }

    @Override
    public void addConstraintMatch(RuleContext kcontext, long weight) {
        this.addConstraintMatch(kcontext, weight, EMPTY_OBJECT_ARRAY);
    }

    private void addConstraintMatch(RuleContext kcontext, long weight, Object ... justifications) {
        this.score += weight;
        this.registerConstraintMatch(kcontext, () -> this.score -= weight, () -> SimpleLongScore.of(weight), justifications);
    }

    @Override
    public SimpleLongScore extractScore(int initScore) {
        return SimpleLongScore.ofUninitialized(initScore, this.score);
    }
}

