/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.stream;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirector;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;

public abstract class AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirectorFactory<Solution_, Score_> {
    private final ConstraintSessionFactory<Solution_, Score_> constraintSessionFactory;
    private final Constraint[] constraints;

    protected AbstractConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, Supplier<InnerConstraintFactory<Solution_>> constraintFactorySupplier) {
        super(solutionDescriptor);
        InnerConstraintFactory<Solution_> constraintFactory = constraintFactorySupplier.get();
        this.constraints = constraintProvider.defineConstraints(constraintFactory);
        if (this.constraints == null) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not return null.\nMaybe return an empty array instead if there are no constraints.");
        }
        if (Arrays.stream(this.constraints).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not contain an element that is null.\nMaybe don't include any null elements in the " + Constraint.class.getSimpleName() + " array.");
        }
        this.constraintSessionFactory = constraintFactory.buildSessionFactory(this.constraints);
    }

    @Override
    public ConstraintStreamScoreDirector<Solution_, Score_> buildScoreDirector(boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        return new ConstraintStreamScoreDirector(this, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public ConstraintSession<Solution_, Score_> newConstraintStreamingSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        return this.constraintSessionFactory.buildSession(constraintMatchEnabled, workingSolution);
    }

    public ConstraintSessionFactory<Solution_, Score_> getConstraintSessionFactory() {
        return this.constraintSessionFactory;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }
}

