/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.stream;

import java.util.Collection;
import java.util.Map;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.stream.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.stream.ConstraintSession;

public class ConstraintStreamScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_>> {
    protected ConstraintSession<Solution_, Score_> session;

    public ConstraintStreamScoreDirector(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetConstraintStreamingSession();
    }

    private void resetConstraintStreamingSession() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = ((AbstractConstraintStreamScoreDirectorFactory)this.scoreDirectorFactory).newConstraintStreamingSession(this.constraintMatchEnabledPreference, this.workingSolution);
        Collection<Object> workingFacts = this.getSolutionDescriptor().getAllFacts(this.workingSolution);
        for (Object fact : workingFacts) {
            this.session.insert(fact);
        }
    }

    @Override
    public Score_ calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score_ score = this.session.calculateScore(this.workingInitScore);
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabledPreference;
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotalMap().");
        }
        return this.session.getConstraintMatchTotalMap();
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getIndictmentMap().");
        }
        return this.session.getIndictmentMap();
    }

    @Override
    public void close() {
        super.close();
        this.session.close();
        this.session = null;
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @PlanningEntity.");
        }
        this.session.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.session.update(entity);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.session.retract(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (problemFact == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") cannot be added to the ScoreDirector.");
        }
        this.session.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.session.update(problemFactOrEntity);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.session.retract(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }

    public ConstraintSession<Solution_, Score_> getSession() {
        return this.session;
    }
}

