/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetScoringNode;

public class BavetNodeBuildPolicy<Solution_> {
    private final BavetConstraintSession session;
    private int nextNodeIndex = 0;
    private Map<String, BavetScoringNode> constraintIdToScoringNodeMap;
    private Map<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode> joinConstraintStreamToJoinBridgeNodeMap = new HashMap<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode>();
    private Map<BavetAbstractNode, BavetAbstractNode> sharableNodeMap = new HashMap<BavetAbstractNode, BavetAbstractNode>();

    public BavetNodeBuildPolicy(BavetConstraintSession session, int constraintCount) {
        this.session = session;
        this.constraintIdToScoringNodeMap = new LinkedHashMap<String, BavetScoringNode>(constraintCount);
    }

    public <Node_ extends BavetAbstractNode> Node_ retrieveSharedNode(Node_ node) {
        BavetAbstractNode sharedNode = this.sharableNodeMap.computeIfAbsent(node, k -> node);
        if (sharedNode != node) {
            this.nextNodeIndex = node.getNodeIndex();
        }
        return (Node_)sharedNode;
    }

    public void addScoringNode(BavetScoringNode scoringNode) {
        this.constraintIdToScoringNodeMap.put(scoringNode.getConstraintId(), scoringNode);
    }

    public BavetConstraintSession getSession() {
        return this.session;
    }

    public int nextNodeIndex() {
        return this.nextNodeIndex++;
    }

    public Map<String, BavetScoringNode> getConstraintIdToScoringNodeMap() {
        return this.constraintIdToScoringNodeMap;
    }

    public Map<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode> getJoinConstraintStreamToJoinBridgeNodeMap() {
        return this.joinConstraintStreamToJoinBridgeNodeMap;
    }

    public List<BavetNode> getCreatedNodes() {
        int expectedMaxNodeIndex;
        SortedMap nodeIndexToNodeMap = this.sharableNodeMap.keySet().stream().collect(Collectors.toMap(k -> k.getNodeIndex(), Function.identity(), (a, b) -> {
            throw new IllegalStateException("Impossible state: 2 nodes (" + a + ", " + b + ") share the same index (" + a.getNodeIndex() + ").");
        }, TreeMap::new));
        int maxNodeIndex = (Integer)nodeIndexToNodeMap.lastKey();
        if (maxNodeIndex != (expectedMaxNodeIndex = nodeIndexToNodeMap.size() - 1)) {
            throw new IllegalStateException("Impossible state: maximum node index (" + maxNodeIndex + ") does not match the expected maximum node index (" + expectedMaxNodeIndex + ").");
        }
        return new ArrayList<BavetNode>(nodeIndexToNodeMap.values());
    }
}

