/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.ancompiler.KieBaseUpdaterANC;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.model.Model;
import org.drools.model.Rule;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.DirectFiringOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSession;

public final class DroolsConstraintSessionFactory<Solution_, Score_ extends Score<Score_>>
implements ConstraintSessionFactory<Solution_, Score_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Model originalModel;
    private final boolean droolsAlphaNetworkCompilationEnabled;
    private final KieBase originalKieBase;
    private final Map<org.kie.api.definition.rule.Rule, DroolsConstraint<Solution_>> compiledRuleToConstraintMap;
    private final Map<String, Rule> constraintToModelRuleMap;
    private KieBase currentKieBase;
    private Set<String> currentlyDisabledConstraintIdSet = null;

    public DroolsConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, Model model, List<DroolsConstraint<Solution_>> constraints, boolean droolsAlphaNetworkCompilationEnabled) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.originalModel = Objects.requireNonNull(model);
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
        this.currentKieBase = this.originalKieBase = DroolsConstraintSessionFactory.buildKieBaseFromModel(model, droolsAlphaNetworkCompilationEnabled);
        this.compiledRuleToConstraintMap = constraints.stream().collect(Collectors.toMap(constraint -> this.currentKieBase.getRule(constraint.getConstraintPackage(), constraint.getConstraintName()), Function.identity()));
        this.constraintToModelRuleMap = constraints.stream().collect(Collectors.toMap(Constraint::getConstraintId, constraint -> model.getRules().stream().filter(rule -> Objects.equals(rule.getName(), constraint.getConstraintName())).filter(rule -> Objects.equals(rule.getPackage(), constraint.getConstraintPackage())).findFirst().orElseThrow(() -> new IllegalStateException("Impossible state: Rule for constraint (" + constraint + ") not found."))));
    }

    private static KieBase buildKieBaseFromModel(Model model, boolean droolsAlphaNetworkCompilationEnabled) {
        KieBaseConfiguration kieBaseConfiguration = KieServices.get().newKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)KieBaseMutabilityOption.DISABLED);
        kieBaseConfiguration.setProperty("drools.propertySpecific", PropertySpecificOption.DISABLED.name());
        InternalKnowledgeBase kieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseConfiguration)kieBaseConfiguration);
        if (droolsAlphaNetworkCompilationEnabled) {
            KieBaseUpdaterANC.generateAndSetInMemoryANC((KieBase)kieBase);
        }
        return kieBase;
    }

    private static KieSession buildKieSessionFromKieBase(KieBase kieBase) {
        KieSessionConfiguration config = KieServices.get().newKieSessionConfiguration();
        config.setOption((KieSessionOption)DirectFiringOption.YES);
        Environment environment = KieServices.get().newEnvironment();
        return kieBase.newKieSession(config, environment);
    }

    public boolean isDroolsAlphaNetworkCompilationEnabled() {
        return this.droolsAlphaNetworkCompilationEnabled;
    }

    @Override
    public ConstraintSession<Solution_, Score_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        AbstractScoreHolder scoreHolder = scoreDefinition.buildScoreHolder(constraintMatchEnabled);
        Object zeroScore = scoreDefinition.getZeroScore();
        LinkedHashSet<String> disabledConstraintIdSet = new LinkedHashSet<String>(0);
        this.compiledRuleToConstraintMap.forEach((compiledRule, constraint) -> {
            Score<?> constraintWeight = constraint.extractConstraintWeight(workingSolution);
            scoreHolder.configureConstraintWeight((org.kie.api.definition.rule.Rule)compiledRule, constraintWeight);
            if (constraintWeight.equals(zeroScore)) {
                disabledConstraintIdSet.add(constraint.getConstraintId());
            }
        });
        if (disabledConstraintIdSet.isEmpty()) {
            this.currentKieBase = this.originalKieBase;
            this.currentlyDisabledConstraintIdSet = null;
        } else if (!disabledConstraintIdSet.equals(this.currentlyDisabledConstraintIdSet)) {
            ModelImpl model = new ModelImpl().withGlobals(this.originalModel.getGlobals());
            this.constraintToModelRuleMap.forEach((constraintId, modelRule) -> {
                if (disabledConstraintIdSet.contains(constraintId)) {
                    return;
                }
                model.addRule(modelRule);
            });
            this.currentKieBase = DroolsConstraintSessionFactory.buildKieBaseFromModel((Model)model, this.droolsAlphaNetworkCompilationEnabled);
            this.currentlyDisabledConstraintIdSet = disabledConstraintIdSet;
        }
        KieSession kieSession = DroolsConstraintSessionFactory.buildKieSessionFromKieBase(this.currentKieBase);
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        kieSession.setGlobal("scoreHolder", scoreHolder);
        return new DroolsConstraintSession(this.solutionDescriptor, kieSession, scoreHolder);
    }
}

