/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalCluster;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.MapValuesIterable;

public class ConsecutiveIntervalDataImpl<IntervalValue_, PointValue_ extends Comparable<PointValue_>> {
    private final NavigableMap<IntervalSplitPoint<IntervalValue_, PointValue_>, IntervalCluster<IntervalValue_, PointValue_>> clusterStartSplitPointToCluster = new TreeMap<IntervalSplitPoint<IntervalValue_, PointValue_>, IntervalCluster<IntervalValue_, PointValue_>>();
    private final NavigableSet<IntervalSplitPoint<IntervalValue_, PointValue_>> splitPointSet;
    private final Iterable<IntervalCluster<IntervalValue_, PointValue_>> valueList = new MapValuesIterable<IntervalSplitPoint<IntervalValue_, PointValue_>, IntervalCluster<IntervalValue_, PointValue_>>(this.clusterStartSplitPointToCluster);

    public ConsecutiveIntervalDataImpl(TreeSet<IntervalSplitPoint<IntervalValue_, PointValue_>> splitPointSet) {
        this.splitPointSet = splitPointSet;
    }

    protected void addInterval(Interval<IntervalValue_, PointValue_> interval) {
        NavigableMap<IntervalSplitPoint<IntervalValue_, PointValue_>, IntervalCluster<IntervalValue_, PointValue_>> intersectedIntervalClusterMap = this.clusterStartSplitPointToCluster.subMap((IntervalSplitPoint)ObjectUtils.defaultIfNull(this.clusterStartSplitPointToCluster.floorKey(interval.getStartSplitPoint()), interval.getStartSplitPoint()), true, interval.getEndSplitPoint(), true);
        if (!intersectedIntervalClusterMap.isEmpty() && ((IntervalCluster)intersectedIntervalClusterMap.get(intersectedIntervalClusterMap.firstKey())).getEndSplitPoint().compareTo(interval.getStartSplitPoint()) < 0) {
            intersectedIntervalClusterMap = intersectedIntervalClusterMap.subMap((IntervalSplitPoint)intersectedIntervalClusterMap.firstKey(), false, (IntervalSplitPoint)intersectedIntervalClusterMap.lastKey(), true);
        }
        if (intersectedIntervalClusterMap.isEmpty()) {
            IntervalSplitPoint<IntervalValue_, PointValue_> start = this.splitPointSet.floor(interval.getStartSplitPoint());
            this.clusterStartSplitPointToCluster.put(start, new IntervalCluster<IntervalValue_, PointValue_>(this.splitPointSet, start));
            return;
        }
        IntervalCluster intervalCluster = (IntervalCluster)intersectedIntervalClusterMap.get(intersectedIntervalClusterMap.firstKey());
        IntervalSplitPoint oldStart = intervalCluster.getStartSplitPoint();
        intervalCluster.addInterval(interval);
        intersectedIntervalClusterMap.tailMap((IntervalSplitPoint)intersectedIntervalClusterMap.firstKey(), false).values().forEach(intervalCluster::mergeIntervalCluster);
        intersectedIntervalClusterMap.tailMap((IntervalSplitPoint)intersectedIntervalClusterMap.firstKey(), false).clear();
        if (oldStart.compareTo(intervalCluster.getStartSplitPoint()) > 0) {
            this.clusterStartSplitPointToCluster.remove(oldStart);
            this.clusterStartSplitPointToCluster.put(intervalCluster.getStartSplitPoint(), intervalCluster);
        }
    }

    protected void removalInterval(Interval<IntervalValue_, PointValue_> interval) {
        Map.Entry<IntervalSplitPoint<IntervalValue_, PointValue_>, IntervalCluster<IntervalValue_, PointValue_>> intervalClusterEntry = this.clusterStartSplitPointToCluster.floorEntry(interval.getStartSplitPoint());
        IntervalCluster<IntervalValue_, PointValue_> intervalCluster = intervalClusterEntry.getValue();
        this.clusterStartSplitPointToCluster.remove(intervalClusterEntry.getKey());
        for (IntervalCluster<IntervalValue_, PointValue_> newIntervalCluster : intervalCluster.removeInterval(interval)) {
            this.clusterStartSplitPointToCluster.put(newIntervalCluster.getStartSplitPoint(), newIntervalCluster);
        }
    }

    public Iterable<IntervalCluster<IntervalValue_, PointValue_>> getIntervalClusters() {
        return this.valueList;
    }

    public String toString() {
        return "ConsecutiveIntervalData{valueList=" + this.valueList + '}';
    }
}

