/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ExtensionFileFilter;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.SolutionDao;

@RunWith(value=Parameterized.class)
public abstract class SolutionDaoTest
extends LoggingTest {
    protected SolutionDao solutionDao;
    protected File solutionFile;

    protected static Collection<Object[]> getSolutionFilesAsParameters(SolutionDao solutionDao) {
        ArrayList<File> fileList = new ArrayList<File>(0);
        File dataDir = solutionDao.getDataDir();
        File unsolvedDataDir = new File(dataDir, "unsolved");
        if (!unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        SolutionDaoTest.addFiles(solutionDao, fileList, unsolvedDataDir);
        File solvedDataDir = new File(dataDir, "solved");
        if (solvedDataDir.exists()) {
            SolutionDaoTest.addFiles(solutionDao, fileList, solvedDataDir);
        }
        Collections.sort(fileList, new ProblemFileComparator());
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    private static void addFiles(SolutionDao solutionDao, List<File> fileList, File directory) {
        List<File> newFileList = Arrays.asList(directory.listFiles((FileFilter)new ExtensionFileFilter(solutionDao.getFileExtension())));
        fileList.addAll(newFileList);
        for (File subDirectory : directory.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)) {
            SolutionDaoTest.addFiles(solutionDao, fileList, subDirectory);
        }
    }

    protected SolutionDaoTest(File solutionFile) {
        this.solutionFile = solutionFile;
    }

    @Before
    public void setUp() {
        this.solutionDao = this.createSolutionDao();
    }

    protected abstract SolutionDao createSolutionDao();

    @Test
    public void readSolution() {
        this.solutionDao.readSolution(this.solutionFile);
    }
}

