/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.persistence;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.machinereassignment.domain.MachineReassignment;
import org.optaplanner.examples.machinereassignment.domain.MrBalancePenalty;
import org.optaplanner.examples.machinereassignment.domain.MrGlobalPenaltyInfo;
import org.optaplanner.examples.machinereassignment.domain.MrLocation;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrNeighborhood;
import org.optaplanner.examples.machinereassignment.domain.MrProcess;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.MrProcessRequirement;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.domain.MrService;
import org.optaplanner.examples.machinereassignment.persistence.MachineReassignmentDao;

public class MachineReassignmentImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        new MachineReassignmentImporter().convertAll();
    }

    public MachineReassignmentImporter() {
        super(new MachineReassignmentDao());
    }

    @Override
    public boolean acceptInputFile(File inputFile) {
        return super.acceptInputFile(inputFile) && inputFile.getName().startsWith("model_");
    }

    @Override
    public boolean acceptInputFileDuringBulkConvert(File inputFile) {
        return !Arrays.asList("model_b_1.txt", "model_b_2.txt", "model_b_3.txt", "model_b_4.txt", "model_b_5.txt", "model_b_6.txt", "model_b_7.txt", "model_b_8.txt", "model_b_9.txt", "model_b_10.txt").contains(inputFile.getName());
    }

    @Override
    public String getInputFileSuffix() {
        return "txt";
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new MachineReassignmentInputBuilder();
    }

    public class MachineReassignmentInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private MachineReassignment machineReassignment;
        private int resourceListSize;
        private List<MrResource> resourceList;
        private List<MrService> serviceList;
        private List<MrMachine> machineList;
        private int processListSize;
        private List<MrProcess> processList;

        public MachineReassignmentInputBuilder() {
            super(MachineReassignmentImporter.this);
        }

        @Override
        public Solution readSolution() throws IOException {
            this.machineReassignment = new MachineReassignment();
            this.machineReassignment.setId(0L);
            this.readResourceList();
            this.readMachineList();
            this.readServiceList();
            this.readProcessList();
            this.readBalancePenaltyList();
            this.readGlobalPenaltyInfo();
            this.readProcessAssignmentList();
            BigInteger possibleSolutionSize = BigInteger.valueOf(this.machineReassignment.getMachineList().size()).pow(this.machineReassignment.getProcessList().size());
            MachineReassignmentImporter.this.logger.info("MachineReassignment {} has {} resources, {} neighborhoods, {} locations, {} machines, {} services, {} processes and {} balancePenalties with a search space of {}.", new Object[]{this.getInputId(), this.machineReassignment.getResourceList().size(), this.machineReassignment.getNeighborhoodList().size(), this.machineReassignment.getLocationList().size(), this.machineReassignment.getMachineList().size(), this.machineReassignment.getServiceList().size(), this.machineReassignment.getProcessList().size(), this.machineReassignment.getBalancePenaltyList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.machineReassignment;
        }

        private void readResourceList() throws IOException {
            this.resourceListSize = this.readIntegerValue();
            this.resourceList = new ArrayList<MrResource>(this.resourceListSize);
            long resourceId = 0L;
            for (int i = 0; i < this.resourceListSize; ++i) {
                String line = this.readStringValue();
                String[] lineTokens = this.splitBySpace(line, 2);
                MrResource resource = new MrResource();
                resource.setId(resourceId);
                resource.setIndex(i);
                resource.setTransientlyConsumed(this.parseBooleanFromNumber(lineTokens[0]));
                resource.setLoadCostWeight(Integer.parseInt(lineTokens[1]));
                this.resourceList.add(resource);
                ++resourceId;
            }
            this.machineReassignment.setResourceList(this.resourceList);
        }

        private void readMachineList() throws IOException {
            MrMachine machine;
            int i;
            int machineListSize = this.readIntegerValue();
            ArrayList<MrNeighborhood> neighborhoodList = new ArrayList<MrNeighborhood>(machineListSize);
            HashMap<Long, MrNeighborhood> idToNeighborhoodMap = new HashMap<Long, MrNeighborhood>(machineListSize);
            ArrayList<MrLocation> locationList = new ArrayList<MrLocation>(machineListSize);
            HashMap<Long, MrLocation> idToLocationMap = new HashMap<Long, MrLocation>(machineListSize);
            this.machineList = new ArrayList<MrMachine>(machineListSize);
            long machineId = 0L;
            ArrayList<MrMachineCapacity> machineCapacityList = new ArrayList<MrMachineCapacity>(machineListSize * this.resourceListSize);
            long machineCapacityId = 0L;
            for (i = 0; i < machineListSize; ++i) {
                machine = new MrMachine();
                machine.setId(machineId);
                this.machineList.add(machine);
                ++machineId;
            }
            for (i = 0; i < machineListSize; ++i) {
                int moveCostOffset;
                machine = this.machineList.get(i);
                String line = this.readStringValue();
                String[] lineTokens = this.splitBySpace(line, (moveCostOffset = 2 + this.resourceListSize * 2) + machineListSize);
                long neighborhoodId = Long.parseLong(lineTokens[0]);
                MrNeighborhood neighborhood = (MrNeighborhood)idToNeighborhoodMap.get(neighborhoodId);
                if (neighborhood == null) {
                    neighborhood = new MrNeighborhood();
                    neighborhood.setId(neighborhoodId);
                    neighborhoodList.add(neighborhood);
                    idToNeighborhoodMap.put(neighborhoodId, neighborhood);
                }
                machine.setNeighborhood(neighborhood);
                long locationId = Long.parseLong(lineTokens[1]);
                MrLocation location = (MrLocation)idToLocationMap.get(locationId);
                if (location == null) {
                    location = new MrLocation();
                    location.setId(locationId);
                    locationList.add(location);
                    idToLocationMap.put(locationId, location);
                }
                machine.setLocation(location);
                ArrayList<MrMachineCapacity> machineCapacityListOfMachine = new ArrayList<MrMachineCapacity>(this.resourceListSize);
                for (int j = 0; j < this.resourceListSize; ++j) {
                    MrMachineCapacity machineCapacity = new MrMachineCapacity();
                    machineCapacity.setId(machineCapacityId);
                    machineCapacity.setMachine(machine);
                    machineCapacity.setResource(this.resourceList.get(j));
                    machineCapacity.setMaximumCapacity(Long.parseLong(lineTokens[2 + j]));
                    machineCapacity.setSafetyCapacity(Long.parseLong(lineTokens[2 + this.resourceListSize + j]));
                    machineCapacityList.add(machineCapacity);
                    machineCapacityListOfMachine.add(machineCapacity);
                    ++machineCapacityId;
                }
                machine.setMachineCapacityList(machineCapacityListOfMachine);
                HashMap<MrMachine, Integer> machineMoveCostMap = new HashMap<MrMachine, Integer>(machineListSize);
                for (int j = 0; j < machineListSize; ++j) {
                    MrMachine toMachine = this.machineList.get(j);
                    int moveCost = Integer.parseInt(lineTokens[moveCostOffset + j]);
                    machineMoveCostMap.put(toMachine, moveCost);
                }
                machine.setMachineMoveCostMap(machineMoveCostMap);
            }
            this.machineReassignment.setNeighborhoodList(neighborhoodList);
            this.machineReassignment.setLocationList(locationList);
            this.machineReassignment.setMachineList(this.machineList);
            this.machineReassignment.setMachineCapacityList(machineCapacityList);
        }

        private void readServiceList() throws IOException {
            MrService service;
            int i;
            int serviceListSize = this.readIntegerValue();
            this.serviceList = new ArrayList<MrService>(serviceListSize);
            long serviceId = 0L;
            for (i = 0; i < serviceListSize; ++i) {
                service = new MrService();
                service.setId(serviceId);
                service.setFromDependencyServiceList(new ArrayList<MrService>(5));
                this.serviceList.add(service);
                ++serviceId;
            }
            for (i = 0; i < serviceListSize; ++i) {
                service = this.serviceList.get(i);
                String line = this.readStringValue();
                String[] lineTokens = this.splitBySpace(line);
                service.setLocationSpread(Integer.parseInt(lineTokens[0]));
                int serviceDependencyListSize = Integer.parseInt(lineTokens[1]);
                ArrayList<MrService> toDependencyServiceList = new ArrayList<MrService>(serviceDependencyListSize);
                for (int j = 0; j < serviceDependencyListSize; ++j) {
                    int toServiceIndex = Integer.parseInt(lineTokens[2 + j]);
                    if (toServiceIndex >= this.serviceList.size()) {
                        throw new IllegalArgumentException("Service with id (" + serviceId + ") has a non existing toServiceIndex (" + toServiceIndex + ").");
                    }
                    MrService toService = this.serviceList.get(toServiceIndex);
                    if (toService.equals(service)) {
                        throw new IllegalStateException("The toService (" + toService + ") cannot be equal to the service (" + service + ").");
                    }
                    toDependencyServiceList.add(toService);
                    toService.getFromDependencyServiceList().add(service);
                }
                service.setToDependencyServiceList(toDependencyServiceList);
                int numberOfTokens = 2 + serviceDependencyListSize;
                if (lineTokens.length == numberOfTokens) continue;
                throw new IllegalArgumentException("Read line (" + line + ") has " + lineTokens.length + " tokens but is expected to contain " + numberOfTokens + " tokens separated by space.");
            }
            this.machineReassignment.setServiceList(this.serviceList);
        }

        private void readProcessList() throws IOException {
            this.processListSize = this.readIntegerValue();
            this.processList = new ArrayList<MrProcess>(this.processListSize);
            long processId = 0L;
            long processRequirementId = 0L;
            for (int i = 0; i < this.processListSize; ++i) {
                String line = this.readStringValue();
                String[] lineTokens = this.splitBySpace(line, 2 + this.resourceListSize);
                MrProcess process = new MrProcess();
                process.setId(processId);
                int serviceIndex = Integer.parseInt(lineTokens[0]);
                if (serviceIndex >= this.serviceList.size()) {
                    throw new IllegalArgumentException("Process with id (" + processId + ") has a non existing serviceIndex (" + serviceIndex + ").");
                }
                MrService service = this.serviceList.get(serviceIndex);
                process.setService(service);
                ArrayList<MrProcessRequirement> processRequirementList = new ArrayList<MrProcessRequirement>(this.resourceListSize);
                for (int j = 0; j < this.resourceListSize; ++j) {
                    MrProcessRequirement processRequirement = new MrProcessRequirement();
                    processRequirement.setId(processRequirementId);
                    processRequirement.setProcess(process);
                    processRequirement.setResource(this.resourceList.get(j));
                    processRequirement.setUsage(Integer.parseInt(lineTokens[1 + j]));
                    processRequirementList.add(processRequirement);
                    ++processRequirementId;
                }
                process.setProcessRequirementList(processRequirementList);
                process.setMoveCost(Integer.parseInt(lineTokens[1 + this.resourceListSize]));
                this.processList.add(process);
                ++processId;
            }
            this.machineReassignment.setProcessList(this.processList);
        }

        private void readBalancePenaltyList() throws IOException {
            int balancePenaltyListSize = this.readIntegerValue();
            ArrayList<MrBalancePenalty> balancePenaltyList = new ArrayList<MrBalancePenalty>(balancePenaltyListSize);
            long balancePenaltyId = 0L;
            for (int i = 0; i < balancePenaltyListSize; ++i) {
                String line = this.readStringValue();
                String[] lineTokens = this.splitBySpace(line, 3);
                MrBalancePenalty balancePenalty = new MrBalancePenalty();
                balancePenalty.setId(balancePenaltyId);
                int originResourceIndex = Integer.parseInt(lineTokens[0]);
                if (originResourceIndex >= this.resourceListSize) {
                    throw new IllegalArgumentException("BalancePenalty with id (" + balancePenaltyId + ") has a non existing originResourceIndex (" + originResourceIndex + ").");
                }
                balancePenalty.setOriginResource(this.resourceList.get(originResourceIndex));
                int targetResourceIndex = Integer.parseInt(lineTokens[1]);
                if (targetResourceIndex >= this.resourceListSize) {
                    throw new IllegalArgumentException("BalancePenalty with id (" + balancePenaltyId + ") has a non existing targetResourceIndex (" + targetResourceIndex + ").");
                }
                balancePenalty.setTargetResource(this.resourceList.get(targetResourceIndex));
                balancePenalty.setMultiplicand(Integer.parseInt(lineTokens[2]));
                balancePenalty.setWeight(this.readIntegerValue());
                balancePenaltyList.add(balancePenalty);
                ++balancePenaltyId;
            }
            this.machineReassignment.setBalancePenaltyList(balancePenaltyList);
        }

        private void readGlobalPenaltyInfo() throws IOException {
            MrGlobalPenaltyInfo globalPenaltyInfo = new MrGlobalPenaltyInfo();
            globalPenaltyInfo.setId(0L);
            String line = this.readStringValue();
            String[] lineTokens = this.splitBySpace(line, 3);
            globalPenaltyInfo.setProcessMoveCostWeight(Integer.parseInt(lineTokens[0]));
            globalPenaltyInfo.setServiceMoveCostWeight(Integer.parseInt(lineTokens[1]));
            globalPenaltyInfo.setMachineMoveCostWeight(Integer.parseInt(lineTokens[2]));
            this.machineReassignment.setGlobalPenaltyInfo(globalPenaltyInfo);
        }

        private void readProcessAssignmentList() {
            String line = this.readOriginalProcessAssignmentLine();
            String[] lineTokens = this.splitBySpace(line, this.processListSize);
            ArrayList<MrProcessAssignment> processAssignmentList = new ArrayList<MrProcessAssignment>(this.processListSize);
            long processAssignmentId = 0L;
            for (int i = 0; i < this.processListSize; ++i) {
                MrProcessAssignment processAssignment = new MrProcessAssignment();
                processAssignment.setId(processAssignmentId);
                processAssignment.setProcess(this.processList.get(i));
                int machineIndex = Integer.parseInt(lineTokens[i]);
                if (machineIndex >= this.machineList.size()) {
                    throw new IllegalArgumentException("ProcessAssignment with id (" + processAssignmentId + ") has a non existing machineIndex (" + machineIndex + ").");
                }
                processAssignment.setOriginalMachine(this.machineList.get(machineIndex));
                processAssignmentList.add(processAssignment);
                ++processAssignmentId;
            }
            this.machineReassignment.setProcessAssignmentList(processAssignmentList);
        }

        /*
         * Exception decompiling
         */
        private String readOriginalProcessAssignmentLine() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

