/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.app.SolveAllTurtleTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class ImportDirSolveAllTurtleTest
extends SolveAllTurtleTest {
    protected AbstractSolutionImporter solutionImporter;

    protected static Collection<Object[]> getImportDirFilesAsParameters(AbstractSolutionImporter solutionImporter) {
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        File importDataDir = solutionImporter.getInputDir();
        if (!importDataDir.exists()) {
            throw new IllegalStateException("The directory importDataDir (" + importDataDir.getAbsolutePath() + ") does not exist.");
        }
        ArrayList fileList = new ArrayList(FileUtils.listFiles((File)importDataDir, (String[])new String[]{solutionImporter.getInputFileSuffix()}, (boolean)true));
        Collections.sort(fileList, new ProblemFileComparator());
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    protected ImportDirSolveAllTurtleTest(File dataFile) {
        super(dataFile);
    }

    @Before
    public void setUp() {
        this.solutionImporter = this.createSolutionImporter();
    }

    protected abstract AbstractSolutionImporter createSolutionImporter();

    @Override
    protected Solution readPlanningProblem() {
        return this.solutionImporter.readSolution(this.dataFile);
    }
}

