/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.persistence.xstream.XStreamProblemIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XStreamSolutionDao
implements SolutionDao {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private XStreamProblemIO xStreamProblemIO;
    private String dirName;
    private File dataDir;

    public XStreamSolutionDao(String dirName, Class ... xstreamAnnotations) {
        this.dirName = dirName;
        this.dataDir = new File("data/" + dirName);
        this.xStreamProblemIO = new XStreamProblemIO(xstreamAnnotations);
        if (!this.dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + this.dataDir.getAbsolutePath() + ") does not exist.\n" + " The working directory should be set to the directory that contains the data directory" + " (which is not the data directory itself).\n" + " The working directory is different in a git clone (optaplanner/optaplanner-examples)" + " and the release zip (examples).\n" + " In an IDE (IntelliJ, Eclipse, NetBeans), open the \"Run configuration\"" + " to change the field \"Working directory\".");
        }
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public String getFileExtension() {
        return "xml";
    }

    @Override
    public Solution readSolution(File inputSolutionFile) {
        Solution solution = this.xStreamProblemIO.read(inputSolutionFile);
        this.logger.info("Opened: {}", (Object)inputSolutionFile);
        return solution;
    }

    @Override
    public void writeSolution(Solution solution, File outputSolutionFile) {
        this.xStreamProblemIO.write(solution, outputSolutionFile);
        this.logger.info("Saved: {}", (Object)outputSolutionFile);
    }
}

