/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;

public class ExaminationPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/examination/swingui/examinationLogo.png";
    private final TimeTablePanel<Room, Period> roomsPanel;

    public ExaminationPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.roomsPanel = new TimeTablePanel();
        tabbedPane.add("Rooms", new JScrollPane(this.roomsPanel));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    private Examination getExamination() {
        return (Examination)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        this.roomsPanel.reset();
        Examination examination = (Examination)solution;
        this.defineGrid(examination);
        this.fillCells(examination);
        this.repaint();
    }

    private void defineGrid(Examination examination) {
        JButton footprint = new JButton("999999");
        footprint.setMargin(new Insets(0, 0, 0, 0));
        int footprintWidth = footprint.getPreferredSize().width;
        this.roomsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Room room : examination.getRoomList()) {
            this.roomsPanel.defineColumnHeader(room, footprintWidth);
        }
        this.roomsPanel.defineColumnHeader(null, footprintWidth);
        this.roomsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Period period : examination.getPeriodList()) {
            this.roomsPanel.defineRowHeader(period);
        }
        this.roomsPanel.defineRowHeader(null);
    }

    private void fillCells(Examination examination) {
        this.roomsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Time")));
        this.fillRoomCells(examination);
        this.fillDayCells(examination);
        this.fillLectureCells(examination);
    }

    private void fillRoomCells(Examination examination) {
        for (Room room : examination.getRoomList()) {
            this.roomsPanel.addColumnHeader(room, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel(room.getLabel(), 0)));
        }
        this.roomsPanel.addColumnHeader(null, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Unassigned", 0)));
    }

    private void fillDayCells(Examination examination) {
        for (Period period : examination.getPeriodList()) {
            this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, period, this.createHeaderPanel(new JLabel(period.getLabel())));
        }
        this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createHeaderPanel(new JLabel("Unassigned")));
    }

    private void fillLectureCells(Examination examination) {
        TangoColorFactory tangoColorFactory = new TangoColorFactory();
        for (Exam exam : examination.getExamList()) {
            Color examColor = tangoColorFactory.pickColor(exam);
            this.roomsPanel.addCell(exam.getRoom(), exam.getPeriod(), this.createButton(exam, examColor));
        }
    }

    private JPanel createHeaderPanel(JLabel label) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private JButton createButton(Exam exam, Color color) {
        JButton button = new JButton(new ExamAction(exam));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBackground(color);
        return button;
    }

    private class ExamAction
    extends AbstractAction {
        private Exam exam;

        public ExamAction(Exam exam) {
            super(exam.getLabel());
            this.exam = exam;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 2));
            listFieldsPanel.add(new JLabel("Period:"));
            List<Period> periodList = ExaminationPanel.this.getExamination().getPeriodList();
            JComboBox<Object> periodListField = new JComboBox<Object>(periodList.toArray());
            periodListField.setSelectedItem(this.exam.getPeriod());
            listFieldsPanel.add(periodListField);
            listFieldsPanel.add(new JLabel("Room:"));
            List<Room> roomList = ExaminationPanel.this.getExamination().getRoomList();
            JComboBox<Object> roomListField = new JComboBox<Object>(roomList.toArray());
            roomListField.setSelectedItem(this.exam.getRoom());
            listFieldsPanel.add(roomListField);
            int result = JOptionPane.showConfirmDialog(ExaminationPanel.this.getRootPane(), listFieldsPanel, "Select period and room", 2);
            if (result == 0) {
                Period toPeriod = (Period)periodListField.getSelectedItem();
                ExaminationPanel.this.solutionBusiness.doChangeMove(this.exam, "period", toPeriod);
                Room toRoom = (Room)roomListField.getSelectedItem();
                ExaminationPanel.this.solutionBusiness.doChangeMove(this.exam, "room", toRoom);
                ExaminationPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

