/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.solver.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;

public class VehicleRoutingIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<VehicleRoutingSolution> {
    private boolean timeWindowed;
    private Map<Vehicle, Integer> vehicleDemandMap;
    private int hardScore;
    private int softScore;

    public void resetWorkingSolution(VehicleRoutingSolution schedule) {
        this.timeWindowed = schedule instanceof TimeWindowedVehicleRoutingSolution;
        List<Vehicle> vehicleList = schedule.getVehicleList();
        this.vehicleDemandMap = new HashMap<Vehicle, Integer>(vehicleList.size());
        for (Vehicle vehicle : vehicleList) {
            this.vehicleDemandMap.put(vehicle, 0);
        }
        this.hardScore = 0;
        this.softScore = 0;
        for (Customer customer : schedule.getCustomerList()) {
            this.insertPreviousStandstill(customer);
            this.insertVehicle(customer);
            if (!this.timeWindowed) continue;
            this.insertMilliArrivalTime((TimeWindowedCustomer)customer);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        if (entity instanceof Vehicle) {
            return;
        }
        this.insertPreviousStandstill((Customer)entity);
        this.insertVehicle((Customer)entity);
        if (this.timeWindowed) {
            this.insertMilliArrivalTime((TimeWindowedCustomer)entity);
        }
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        if (entity instanceof Vehicle) {
            return;
        }
        if (variableName.equals("previousStandstill")) {
            this.retractPreviousStandstill((Customer)entity);
        } else if (variableName.equals("vehicle")) {
            this.retractVehicle((Customer)entity);
        } else if (variableName.equals("nextCustomer")) {
            this.retractNextCustomer((Customer)entity);
        } else if (variableName.equals("milliArrivalTime")) {
            this.retractMilliArrivalTime((TimeWindowedCustomer)entity);
        } else {
            throw new IllegalArgumentException("Unsupported variableName (" + variableName + ").");
        }
    }

    public void afterVariableChanged(Object entity, String variableName) {
        if (entity instanceof Vehicle) {
            return;
        }
        if (variableName.equals("previousStandstill")) {
            this.insertPreviousStandstill((Customer)entity);
        } else if (variableName.equals("vehicle")) {
            this.insertVehicle((Customer)entity);
        } else if (variableName.equals("nextCustomer")) {
            this.insertNextCustomer((Customer)entity);
        } else if (variableName.equals("milliArrivalTime")) {
            this.insertMilliArrivalTime((TimeWindowedCustomer)entity);
        } else {
            throw new IllegalArgumentException("Unsupported variableName (" + variableName + ").");
        }
    }

    public void beforeEntityRemoved(Object entity) {
        if (entity instanceof Vehicle) {
            return;
        }
        this.retractPreviousStandstill((Customer)entity);
        this.retractVehicle((Customer)entity);
        if (this.timeWindowed) {
            this.retractMilliArrivalTime((TimeWindowedCustomer)entity);
        }
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insertPreviousStandstill(Customer customer) {
        Standstill previousStandstill = customer.getPreviousStandstill();
        if (previousStandstill != null) {
            this.softScore -= customer.getMilliDistanceToPreviousStandstill();
        }
    }

    private void retractPreviousStandstill(Customer customer) {
        Standstill previousStandstill = customer.getPreviousStandstill();
        if (previousStandstill != null) {
            this.softScore += customer.getMilliDistanceToPreviousStandstill();
        }
    }

    private void insertVehicle(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null) {
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand + customer.getDemand();
            this.hardScore += Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0);
            this.vehicleDemandMap.put(vehicle, newDemand);
            if (customer.getNextCustomer() == null) {
                this.softScore -= vehicle.getLocation().getMilliDistance(customer.getLocation());
            }
        }
    }

    private void retractVehicle(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null) {
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand - customer.getDemand();
            this.hardScore += Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0);
            this.vehicleDemandMap.put(vehicle, newDemand);
            if (customer.getNextCustomer() == null) {
                this.softScore += vehicle.getLocation().getMilliDistance(customer.getLocation());
            }
        }
    }

    private void insertNextCustomer(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null && customer.getNextCustomer() == null) {
            this.softScore -= vehicle.getLocation().getMilliDistance(customer.getLocation());
        }
    }

    private void retractNextCustomer(Customer customer) {
        Vehicle vehicle = customer.getVehicle();
        if (vehicle != null && customer.getNextCustomer() == null) {
            this.softScore += vehicle.getLocation().getMilliDistance(customer.getLocation());
        }
    }

    private void insertMilliArrivalTime(TimeWindowedCustomer customer) {
        int milliDueTime;
        Integer milliArrivalTime = customer.getMilliArrivalTime();
        if (milliArrivalTime != null && (milliDueTime = customer.getMilliDueTime()) < milliArrivalTime) {
            this.hardScore -= milliArrivalTime - milliDueTime;
        }
    }

    private void retractMilliArrivalTime(TimeWindowedCustomer customer) {
        int milliDueTime;
        Integer milliArrivalTime = customer.getMilliArrivalTime();
        if (milliArrivalTime != null && (milliDueTime = customer.getMilliDueTime()) < milliArrivalTime) {
            this.hardScore += milliArrivalTime - milliDueTime;
        }
    }

    public HardSoftScore calculateScore() {
        return HardSoftScore.valueOf((int)this.hardScore, (int)this.softScore);
    }
}

