/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import org.apache.commons.lang.ObjectUtils;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.XmlSolverFactory;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.simple.SimpleScoreCalculator;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.app.LoggingTest;

@RunWith(value=Parameterized.class)
public abstract class SolveAllTurtleTest
extends LoggingTest {
    protected File dataFile;

    protected static void checkRunTurtleTests() {
        Assume.assumeTrue((boolean)ObjectUtils.equals((Object)"true", (Object)System.getProperty("runTurtleTests")));
    }

    protected SolveAllTurtleTest(File dataFile) {
        this.dataFile = dataFile;
    }

    protected abstract String createSolverConfigResource();

    protected abstract Solution readPlanningProblem();

    @Test
    public void runFastAndFullAssert() {
        SolveAllTurtleTest.checkRunTurtleTests();
        SolverFactory solverFactory = this.buildSolverFactory();
        Solution planningProblem = this.readPlanningProblem();
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, planningProblem, 2L);
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.FAST_ASSERT, planningProblem, 5L);
        planningProblem = this.buildAndSolve(solverFactory, EnvironmentMode.NON_INTRUSIVE_FULL_ASSERT, planningProblem, 3L);
    }

    protected Solution buildAndSolve(SolverFactory solverFactory, EnvironmentMode environmentMode, Solution planningProblem, long maximumMinutesSpent) {
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        solverConfig.getTerminationConfig().setMinutesSpentLimit(Long.valueOf(maximumMinutesSpent));
        solverConfig.setEnvironmentMode(environmentMode);
        Class<? extends SimpleScoreCalculator> simpleScoreCalculatorClass = this.overwritingSimpleScoreCalculatorClass();
        if (simpleScoreCalculatorClass != null && environmentMode.isAsserted()) {
            ScoreDirectorFactoryConfig assertionScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            assertionScoreDirectorFactoryConfig.setSimpleScoreCalculatorClass(simpleScoreCalculatorClass);
            solverConfig.getScoreDirectorFactoryConfig().setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryConfig);
        }
        Solver solver = solverFactory.buildSolver();
        solver.solve(planningProblem);
        Solution bestSolution = solver.getBestSolution();
        if (bestSolution == null) {
            bestSolution = planningProblem;
        }
        return bestSolution;
    }

    protected Class<? extends SimpleScoreCalculator> overwritingSimpleScoreCalculatorClass() {
        return null;
    }

    protected SolverFactory buildSolverFactory() {
        XmlSolverFactory solverFactory = new XmlSolverFactory(this.createSolverConfigResource());
        TerminationConfig terminationConfig = new TerminationConfig();
        solverFactory.getSolverConfig().setTerminationConfig(terminationConfig);
        return solverFactory;
    }
}

